/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.SchemaFactory;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.serialization.SerializationUtility;
import org.eclipse.scout.rt.platform.util.Base64Utility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtility {
    private static final Logger LOG = LoggerFactory.getLogger(XmlUtility.class);
    public static final String INDENT_AMOUNT_TRANSFORMER_PROPERTY = "{http://xml.apache.org/xslt}indent-amount";

    private XmlUtility() {
    }

    public static SchemaFactory newSchemaFactory() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (SAXException e) {
            LOG.warn("Property '{}' cannot be set in the current SchemaFactory: {}", new Object[]{"http://javax.xml.XMLConstants/property/accessExternalDTD", factory.getClass().getName(), e});
        }
        try {
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (SAXException e) {
            LOG.warn("Property '{}' cannot be set in the current SchemaFactory: {}", new Object[]{"http://javax.xml.XMLConstants/property/accessExternalSchema", factory.getClass().getName(), e});
        }
        return factory;
    }

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        for (Map.Entry<String, Boolean> a : XmlUtility.getXmlFeaturesMap().entrySet()) {
            String feature = a.getKey();
            boolean enabled = a.getValue();
            try {
                factory.setFeature(feature, enabled);
            }
            catch (ParserConfigurationException e) {
                LOG.warn("Feature '{}' is not supported in the current XML parser: {}", new Object[]{feature, factory.getClass().getName(), e});
            }
        }
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Attribute '{}' is not supported in the current DocumentBuilderFactory: {}", new Object[]{"http://javax.xml.XMLConstants/property/accessExternalDTD", factory.getClass().getName(), e});
        }
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Attribute '{}' is not supported in the current DocumentBuilderFactory: {}", new Object[]{"http://javax.xml.XMLConstants/property/accessExternalSchema", factory.getClass().getName(), e});
        }
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        factory.setIgnoringComments(true);
        return factory.newDocumentBuilder();
    }

    private static Map<String, Boolean> getXmlFeaturesMap() {
        HashMap<String, Boolean> features = new HashMap<String, Boolean>(5);
        features.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        features.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        features.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        features.put("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        return features;
    }

    public static XMLInputFactory newXMLInputFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            factory.setProperty("javax.xml.stream.supportDTD", false);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Attribute '{}' is not supported in the current XMLInputFactory: {}", new Object[]{"javax.xml.stream.supportDTD", factory.getClass().getName(), e});
        }
        try {
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Attribute '{}' is not supported in the current XMLInputFactory: {}", new Object[]{"javax.xml.stream.isSupportingExternalEntities", factory.getClass().getName(), e});
        }
        return factory;
    }

    public static Transformer newTransformer() throws TransformerConfigurationException {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            LOG.debug("Feature '{}' is not supported in the current TransformerFactory: {}", new Object[]{"http://javax.xml.XMLConstants/feature/secure-processing", tf.getClass().getName(), e});
        }
        try {
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Attribute '{}' is not supported in the current TransformerFactory: {}", new Object[]{"http://javax.xml.XMLConstants/property/accessExternalDTD", tf.getClass().getName(), e});
        }
        try {
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Attribute '{}' is not supported in the current TransformerFactory: {}", new Object[]{"http://javax.xml.XMLConstants/property/accessExternalDTD", tf.getClass().getName(), e});
        }
        return tf.newTransformer();
    }

    public static SAXParser newSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        for (Map.Entry<String, Boolean> a : XmlUtility.getXmlFeaturesMap().entrySet()) {
            String feature = a.getKey();
            boolean enabled = a.getValue();
            try {
                factory.setFeature(feature, enabled);
            }
            catch (ParserConfigurationException e) {
                LOG.warn("Feature '{}' is not supported in the current XML parser: {}", new Object[]{feature, factory.getClass().getName(), e});
            }
        }
        factory.setXIncludeAware(false);
        factory.setValidating(false);
        return factory.newSAXParser();
    }

    public static List<Element> getChildElementsWithAttributes(Element parent, String tagName, String requiredAttributeName, String requiredAttributeValue) {
        NodeList endpoints = parent.getChildNodes();
        LinkedList<Element> result = new LinkedList<Element>();
        int i = 0;
        while (i < endpoints.getLength()) {
            String val;
            Element e;
            Node n = endpoints.item(i);
            if (n.getNodeType() == 1 && tagName.equals(n.getNodeName()) && (e = (Element)n).hasAttribute(requiredAttributeName) && ObjectUtility.equals(requiredAttributeValue, val = e.getAttribute(requiredAttributeName))) {
                result.add(e);
            }
            ++i;
        }
        return result;
    }

    public static void clearAttributes(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            element.removeAttribute(attributes.item(i).getNodeName());
            ++i;
        }
    }

    public static Object getObjectAttribute(Element element, String attribName) throws IOException, ClassNotFoundException {
        Object o = null;
        String base64 = element.getAttribute(attribName);
        if (!base64.isEmpty()) {
            byte[] raw = Base64Utility.decode(base64);
            o = SerializationUtility.createObjectSerializer().deserialize(raw, null);
        }
        return o;
    }

    public static void setObjectAttribute(Element element, String attribName, Object o) throws IOException {
        String base64 = null;
        if (o != null) {
            byte[] data = SerializationUtility.createObjectSerializer().serialize(o);
            base64 = Base64Utility.encode(data).trim();
        }
        element.setAttribute(attribName, base64);
    }

    public static void wellformDocument(Document document, OutputStream out) {
        XmlUtility.wellformDocument(document, new StreamResult(out));
        try {
            out.flush();
        }
        catch (IOException e) {
            throw new ProcessingException("unable to flush xml document to output.", new Object[]{e});
        }
    }

    public static void wellformDocument(Document document, File f) {
        boolean success2;
        File dir = f.getParentFile();
        if (!dir.exists() && !(success2 = dir.mkdirs())) {
            throw new ProcessingException("Unable to create directories for file '" + f.getAbsolutePath() + "'.", new Object[0]);
        }
        try {
            Throwable success2 = null;
            Object var4_7 = null;
            try (FileOutputStream out = new FileOutputStream(f, false);){
                XmlUtility.wellformDocument(document, out);
            }
            catch (Throwable throwable) {
                if (success2 == null) {
                    success2 = throwable;
                } else if (success2 != throwable) {
                    success2.addSuppressed(throwable);
                }
                throw success2;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Exception writing xml file: '" + f.getAbsolutePath() + "'.", new Object[]{e});
        }
    }

    public static void wellformDocument(Document document, Writer writer) {
        XmlUtility.wellformDocument(document, new StreamResult(writer));
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new ProcessingException("unable to flush xml document to writer.", new Object[]{e});
        }
    }

    private static void wellformDocument(Document document, Result result) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty(INDENT_AMOUNT_TRANSFORMER_PROPERTY, "2");
            transformer.transform(new DOMSource(document), result);
        }
        catch (TransformerException e) {
            throw new ProcessingException("Unable to wellform xml.", new Object[]{e});
        }
    }

    public static String wellformDocument(Document document) {
        StringWriter writer = new StringWriter();
        XmlUtility.wellformDocument(document, new StreamResult(writer));
        return writer.getBuffer().toString();
    }

    public static String wellformXml(String rawXml) {
        return XmlUtility.wellformDocument(XmlUtility.getXmlDocument(rawXml));
    }

    public static Document createNewXmlDocument(String rootTagName) {
        try {
            DocumentBuilder docBuilder = XmlUtility.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            document.appendChild(document.createElement(rootTagName));
            return document;
        }
        catch (ParserConfigurationException e) {
            LOG.debug("Could not create new xml document", (Throwable)e);
            return null;
        }
    }

    public static Document getXmlDocument(InputStream is) {
        try {
            return XmlUtility.newDocumentBuilder().parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ProcessingException("Unable to load xml document.", new Object[]{e});
        }
    }

    public static Document getXmlDocument(File f) {
        try {
            return XmlUtility.newDocumentBuilder().parse(f);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ProcessingException("Unable to load xml document.", new Object[]{e});
        }
    }

    public static Document getXmlDocument(URL url) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = url.openStream();){
                return XmlUtility.getXmlDocument(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Unable to open URL '" + url.toExternalForm() + "'.", new Object[]{e});
        }
    }

    public static Document getXmlDocument(String rawXml) {
        try {
            return XmlUtility.newDocumentBuilder().parse(new InputSource(new StringReader(rawXml)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ProcessingException("Unable to load xml document.", new Object[]{e});
        }
    }

    public static Element getFirstChildElement(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1 && (tagName == null || tagName.equals(n.getNodeName()))) {
                return (Element)n;
            }
            ++i;
        }
        return null;
    }

    public static List<Element> getChildElements(Element parent) {
        return XmlUtility.getChildElements(parent, null);
    }

    public static List<Element> getChildElements(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        ArrayList<Element> result = new ArrayList<Element>(children.getLength());
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n.getNodeType() == 1 && (tagName == null || tagName.equals(n.getNodeName()))) {
                result.add((Element)n);
            }
            ++i;
        }
        return result;
    }
}

