/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public final class VerboseUtility {
    private VerboseUtility() {
    }

    public static String dumpGenerics(Type ... types) {
        HashMap<Type, String> longDesc = new HashMap<Type, String>();
        StringBuilder buf = new StringBuilder();
        buf.append(VerboseUtility.dumpGenericsRec(new HashMap<Type, String>(), longDesc, types));
        longDesc.remove(Object.class);
        if (!longDesc.isEmpty()) {
            buf.append(" WITH ");
            for (String s : longDesc.values()) {
                buf.append(" ");
                buf.append(s);
            }
        }
        return buf.toString();
    }

    private static String dumpGenericsRec(Map<Type, String> shortDecl, Map<Type, String> longDecl, Type ... types) {
        if (types == null || types.length == 0) {
            return "";
        }
        if (types.length == 1) {
            return VerboseUtility.dumpGenericsImpl(shortDecl, longDecl, types[0]);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append(VerboseUtility.dumpGenericsImpl(shortDecl, longDecl, t));
            ++n2;
        }
        buf.append("}");
        return buf.toString();
    }

    private static String dumpGenericsImpl(Map<Type, String> shortDecl, Map<Type, String> longDecl, Type type) {
        String shortText = shortDecl.get(type);
        if (shortText != null) {
            return shortText;
        }
        if (type == null) {
            shortText = "null";
        } else if (type instanceof Class) {
            Class c = (Class)type;
            shortText = "Class[" + c.getSimpleName() + "]";
        } else if (type instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)type;
            shortText = "GenericArrayType[" + VerboseUtility.dumpGenericsRec(shortDecl, longDecl, g.getGenericComponentType()) + "]";
        } else if (type instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)type;
            shortText = "ParameterizedType[" + VerboseUtility.dumpGenericsRec(shortDecl, longDecl, p.getActualTypeArguments()) + "]";
        } else if (type instanceof TypeVariable) {
            TypeVariable v = (TypeVariable)type;
            shortText = "TypeVariable[" + v.getName() + "]";
        } else if (type instanceof WildcardType) {
            WildcardType w = (WildcardType)type;
            shortText = "WildcardType[" + VerboseUtility.dumpGenericsRec(shortDecl, longDecl, w.getLowerBounds()) + ", " + VerboseUtility.dumpGenericsRec(shortDecl, longDecl, w.getUpperBounds()) + "]";
        } else {
            shortText = "UNKNOWN[" + type.getClass().getSimpleName() + "]";
        }
        shortDecl.put(type, shortText);
        String longText = null;
        if (type != null) {
            if (type instanceof Class) {
                Class c = (Class)type;
                longText = "Class[name=" + c.getName() + ", typeParameters=" + VerboseUtility.dumpGenericsRec(shortDecl, longDecl, c.getTypeParameters()) + "]";
            } else if (!(type instanceof GenericArrayType) && !(type instanceof ParameterizedType) && !(type instanceof TypeVariable) && type instanceof WildcardType) {
                WildcardType w = (WildcardType)type;
                longText = "WildcardType[lowerBounds=" + VerboseUtility.dumpGenericsRec(shortDecl, longDecl, w.getLowerBounds()) + ", upperBounds=" + VerboseUtility.dumpGenericsRec(shortDecl, longDecl, w.getUpperBounds()) + "]";
            }
        }
        if (longText != null) {
            longDecl.put(type, longText);
        }
        return shortText;
    }

    public static String dumpType(Class cls) {
        if (cls == null) {
            return "null";
        }
        Class<?> compClass = cls;
        String dim = "";
        while (compClass.isArray()) {
            dim = String.valueOf(dim) + "[]";
            compClass = compClass.getComponentType();
        }
        Package pkg = compClass.getPackage();
        String s = compClass.getName();
        if (pkg != null) {
            s = s.substring(pkg.getName().length() + 1);
        }
        return String.valueOf(s) + dim;
    }

    public static String dumpObject(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            int n = Array.getLength(o);
            if (n > 100) {
                n = 100;
            }
            int i = 0;
            while (i < n) {
                buf.append(VerboseUtility.dumpObject(Array.get(o, i)));
                if (i + 1 < n) {
                    buf.append(",");
                }
                ++i;
            }
            if (Array.getLength(o) > n) {
                buf.append(",...");
            }
            buf.append("]");
            return buf.toString();
        }
        if (o.getClass() == Byte.class) {
            Byte b = (Byte)o;
            String s = Integer.toHexString(b.intValue() & 0xFF);
            if (s.length() < 2) {
                s = "0" + s;
            }
            return s;
        }
        if (o instanceof Subject) {
            Subject s = (Subject)o;
            Set<Principal> set = s.getPrincipals();
            if (!set.isEmpty()) {
                return set.iterator().next().getName();
            }
            return s.toString();
        }
        return "" + o;
    }

    public static String dumpTypeAndObject(Object o) {
        if (o == null) {
            return "null";
        }
        return String.valueOf(VerboseUtility.dumpType(o.getClass())) + ":" + VerboseUtility.dumpObject(o);
    }

    public static String dumpObjects(Object[] args) {
        if (args == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            buf.append(VerboseUtility.dumpObject(args[i]));
            if (i + 1 < args.length) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }
}

