/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.UriUtility;

public class UriBuilder {
    private static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private String m_scheme;
    private String m_host;
    private int m_port = -1;
    private String m_path;
    private final Map<String, String> m_parameters = new LinkedHashMap<String, String>();
    private String m_fragment;

    public UriBuilder() {
    }

    public UriBuilder(String uri) {
        this(uri, DEFAULT_ENCODING);
    }

    public UriBuilder(String uri, String encoding) {
        this(UriUtility.toUri(uri), encoding);
    }

    public UriBuilder(URL url) {
        this(UriUtility.urlToUri(url), DEFAULT_ENCODING);
    }

    public UriBuilder(URI uri) {
        this(uri, DEFAULT_ENCODING);
    }

    public UriBuilder(URL url, String encoding) {
        this(UriUtility.urlToUri(url), encoding);
    }

    public UriBuilder(URI uri, String encoding) {
        if (uri == null) {
            return;
        }
        this.m_scheme = uri.getScheme();
        this.m_host = uri.getHost();
        this.m_port = uri.getPort();
        this.m_path = uri.getPath();
        this.m_fragment = uri.getFragment();
        Map<String, String> params = UriUtility.getQueryParameters(uri, encoding);
        this.m_parameters.putAll(params);
    }

    public UriBuilder scheme(String scheme) {
        this.m_scheme = scheme;
        return this;
    }

    public UriBuilder host(String host) {
        this.m_host = host;
        return this;
    }

    public UriBuilder port(int port) {
        this.m_port = port < 1 ? -1 : port;
        return this;
    }

    public UriBuilder path(String path) {
        this.m_path = path;
        return this;
    }

    public UriBuilder addPath(String path) {
        if (StringUtility.hasText(path)) {
            this.m_path = StringUtility.join("/", this.removeTrailingSlash(this.m_path), path);
        }
        this.ensureAbsolutePathWithHost();
        return this;
    }

    private String removeTrailingSlash(String path) {
        if (path != null && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public UriBuilder fragment(String fragment) {
        this.m_fragment = fragment;
        return this;
    }

    public UriBuilder queryString(String queryString) {
        String[] keyValuePairs;
        String[] stringArray = keyValuePairs = StringUtility.split(queryString, "&");
        int n = keyValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            String keyValuePair = stringArray[n2];
            String[] keyValue = keyValuePair.split("=", 2);
            this.parameter(keyValue[0], keyValue.length == 2 ? keyValue[1] : "");
            ++n2;
        }
        return this;
    }

    public UriBuilder parameter(String name, String value) {
        if (!StringUtility.hasText(name)) {
            return this;
        }
        if (value == null) {
            this.m_parameters.remove(name);
        } else {
            this.m_parameters.put(name, value);
        }
        return this;
    }

    public UriBuilder parameters(Map<String, String> parameters) {
        if (parameters != null) {
            parameters.forEach((name, value) -> {
                UriBuilder uriBuilder = this.parameter((String)name, (String)value);
            });
        }
        return this;
    }

    public URL createURL() {
        return this.createURL(DEFAULT_ENCODING);
    }

    public URI createURI() {
        return this.createURI(DEFAULT_ENCODING);
    }

    public URL createURL(String encoding) {
        URI uri = this.createURI(encoding);
        return UriUtility.uriToUrl(uri);
    }

    public URI createURI(String encoding) {
        try {
            return this.createURIInternal(encoding);
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("error creating URI", new Object[]{e});
        }
    }

    private URI createURIInternal(String encoding) throws URISyntaxException {
        URI uri = new URI(this.m_scheme, null, this.m_host, this.m_port, this.m_path, null, null);
        String urlWithQuery = StringUtility.join("?", uri.toString(), this.getQueryString(encoding));
        String fullUrl = StringUtility.join("#", urlWithQuery, this.m_fragment);
        return new URI(fullUrl);
    }

    private void ensureAbsolutePathWithHost() {
        if (this.m_host != null && !this.m_host.isEmpty() && this.m_path != null && !this.m_path.startsWith("/")) {
            this.m_path = "/" + this.m_path;
        }
    }

    private String getQueryString(String encoding) {
        Assertions.assertNotNull(encoding);
        if (this.m_parameters.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> param : this.m_parameters.entrySet()) {
            if (!StringUtility.hasText(param.getKey())) continue;
            if (query.length() > 0) {
                query.append("&");
            }
            query.append(UriUtility.encode(param.getKey(), encoding));
            if (StringUtility.isNullOrEmpty(param.getValue())) continue;
            query.append("=");
            query.append(UriUtility.encode(param.getValue(), encoding));
        }
        return query.toString();
    }

    public String getScheme() {
        return this.m_scheme;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getFragment() {
        return this.m_fragment;
    }

    public Map<String, String> getParameters() {
        return new LinkedHashMap<String, String>(this.m_parameters);
    }
}

