/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public final class ObjectUtility {
    private ObjectUtility() {
    }

    public static <T> T nvl(T value, T valueWhenNull) {
        if (value != null) {
            return value;
        }
        return valueWhenNull;
    }

    public static <T> T nvlOptional(T value, Supplier<T> valueSupplierWhenNull) {
        if (value != null) {
            return value;
        }
        return valueSupplierWhenNull != null ? (T)valueSupplierWhenNull.get() : null;
    }

    public static <T> boolean equals(T a, T b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof Timestamp && !(b instanceof Timestamp)) {
            return b.equals(a);
        }
        if (a.equals(b)) {
            return true;
        }
        if (a.getClass().isArray() && b.getClass().isArray()) {
            int nb;
            int na = Array.getLength(a);
            if (na != (nb = Array.getLength(b))) {
                return false;
            }
            int i = 0;
            while (i < na) {
                if (!ObjectUtility.equals(Array.get(a, i), Array.get(b, i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static <T> boolean notEquals(T a, T b) {
        return !ObjectUtility.equals(a, b);
    }

    public static <T extends Comparable<T>> int compareTo(T a, T b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static String toString(Object value) {
        return Objects.toString(value, null);
    }

    public static boolean isOneOf(Object o, Object ... elements) {
        if (elements == null) {
            return false;
        }
        return ObjectUtility.isOneOf(o, Arrays.asList(elements));
    }

    public static boolean isOneOf(Object o, Collection<?> elements) {
        if (CollectionUtility.isEmpty(elements)) {
            return false;
        }
        for (Object e : elements) {
            if (!ObjectUtility.equals(o, e)) continue;
            return true;
        }
        return false;
    }
}

