/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.Assertions;

public class FinalValue<VALUE> {
    private static final Object NULL_VALUE = new Object();
    private final AtomicReference<Object> m_value = new AtomicReference<Object>(NULL_VALUE);

    public VALUE get() {
        Object value = this.m_value.get();
        return (VALUE)(value == NULL_VALUE ? null : value);
    }

    public void set(VALUE value) {
        Assertions.assertSame(this.m_value.get(), NULL_VALUE, "{} already set.", this.getClass().getSimpleName());
        this.setIfAbsent(value);
    }

    public VALUE setIfAbsentAndGet(VALUE value) {
        return (VALUE)this.setIfAbsentAndGet(() -> value);
    }

    public VALUE setIfAbsentAndGet(Callable<VALUE> producer) {
        this.setIfAbsent(producer);
        return (VALUE)this.m_value.get();
    }

    public boolean setIfAbsent(VALUE value) {
        return this.setIfAbsent(() -> value);
    }

    public boolean setIfAbsent(Callable<VALUE> producer) {
        Object value = this.m_value.get();
        if (value != NULL_VALUE) {
            return false;
        }
        try {
            return this.m_value.compareAndSet(NULL_VALUE, producer.call());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PlatformException("Failed to produce final value", new Object[]{e});
        }
    }

    public boolean isSet() {
        return this.m_value.get() != NULL_VALUE;
    }
}

