/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.awt.Color;
import java.util.regex.Pattern;

public final class ColorUtility {
    public static final Pattern HEX_COLOR_PATTERN = Pattern.compile("^(\\#|0X|0x)?([0-9A-Fa-f]{6})$");
    public static final String RED = "ff0000";
    public static final String GREEN = "00ff00";
    public static final String BLUE = "0000ff";
    public static final String BLACK = "000000";
    public static final String WHITE = "ffffff";
    public static final String CYAN = "00ffff";
    public static final String YELLOW = "ffff00";
    public static final String MAGENTA = "ff00ff";

    private ColorUtility() {
    }

    public static int hsb2rgb(int hsbHex) {
        int hue = hsbHex >> 16 & 0xFF;
        int saturation = hsbHex >> 8 & 0xFF;
        int brightness = hsbHex & 0xFF;
        return ColorUtility.hsb2rgb(hue, saturation, brightness);
    }

    public static int hsb2rgb(float hue, float saturation, float brightness) {
        return Color.HSBtoRGB(hue, saturation, brightness);
    }

    public static String rgbToText(int red, int green, int blue) {
        return String.format("#%02x%02x%02x", red, green, blue);
    }
}

