/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class AlphanumericComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean m_ignoreCase;
    private static final Pattern NUM_OR_TEXT_PATTERN = Pattern.compile("(?:([0-9]+)|([^0-9]+))", 32);

    public AlphanumericComparator() {
        this(false);
    }

    public AlphanumericComparator(boolean ignoreCase) {
        this.m_ignoreCase = ignoreCase;
    }

    public boolean isIgnoreCase() {
        return this.m_ignoreCase;
    }

    @Override
    public int compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        Matcher m1 = NUM_OR_TEXT_PATTERN.matcher(s1);
        Matcher m2 = NUM_OR_TEXT_PATTERN.matcher(s2);
        boolean found1 = m1.find();
        boolean found2 = m2.find();
        while (found1 && found2) {
            String n1 = m1.group(1);
            String n2 = m2.group(1);
            int result = n1 != null && n2 != null ? (n1.length() <= 18 && n2.length() <= 18 ? this.compareAsLongs(Long.parseLong(n1), Long.parseLong(n2)) : this.compareAsBigIntegers(new BigInteger(n1), new BigInteger(n2))) : this.compareAsStrings(m1.group(2), m2.group(2));
            if (result != 0) {
                return result;
            }
            found1 = m1.find();
            found2 = m2.find();
        }
        return this.compareFound(found1, found2);
    }

    protected int compareAsLongs(Long n1, Long n2) {
        return n1.compareTo(n2);
    }

    protected int compareAsBigIntegers(BigInteger n1, BigInteger n2) {
        return n1.compareTo(n2);
    }

    protected int compareAsStrings(String s1, String s2) {
        return this.isIgnoreCase() ? StringUtility.compareIgnoreCase(s1, s2) : StringUtility.compare(s1, s2);
    }

    protected int compareFound(boolean f1, boolean f2) {
        if (!f1 && f2) {
            return -1;
        }
        if (f1 && !f2) {
            return 1;
        }
        return 0;
    }
}

