/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.transaction;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.platform.transaction.ITransactionMember;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class BasicTransaction
implements ITransaction {
    private static final Logger LOG = LoggerFactory.getLogger(BasicTransaction.class);
    private final Object m_memberMapLock = new Object();
    private final Map<String, ITransactionMember> m_memberMap = new LinkedHashMap<String, ITransactionMember>();
    private final List<Throwable> m_failures = new ArrayList<Throwable>();
    private boolean m_commitPhase;
    private boolean m_cancelled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMember(ITransactionMember member) {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            ITransactionMember old;
            String memberId = member.getMemberId();
            if (LOG.isDebugEnabled()) {
                LOG.debug("register transaction member {}", (Object)memberId);
            }
            if ((old = this.m_memberMap.get(memberId)) != null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("releasing overwritten transaction member {} / {}.", (Object)memberId, (Object)old.getMemberId());
                }
                old.release();
            }
            this.m_memberMap.put(memberId, member);
            if (this.m_cancelled) {
                throw new FutureCancelledError("Transaction cancelled", new Object[0]);
            }
        }
    }

    @Override
    public <TRANSACTION_MEMBER extends ITransactionMember> TRANSACTION_MEMBER registerMemberIfAbsent(String memberId, Function<String, TRANSACTION_MEMBER> producer) {
        return this.registerMemberIfAbsent(memberId, producer, true);
    }

    @Override
    public <TRANSACTION_MEMBER extends ITransactionMember> TRANSACTION_MEMBER registerMemberIfAbsentAndNotCancelled(String memberId, Function<String, TRANSACTION_MEMBER> producer) {
        return this.registerMemberIfAbsent(memberId, producer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <TRANSACTION_MEMBER extends ITransactionMember> TRANSACTION_MEMBER registerMemberIfAbsent(String memberId, Function<String, TRANSACTION_MEMBER> producer, boolean throwIfCancelled) {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            ITransactionMember member = this.getMember(memberId);
            if (member == null) {
                if (!throwIfCancelled && this.m_cancelled) {
                    return null;
                }
                member = (ITransactionMember)producer.apply(memberId);
                this.registerMember(member);
            }
            return (TRANSACTION_MEMBER)member;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransactionMember getMember(String memberId) {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            ITransactionMember res = this.m_memberMap.get(memberId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("get transaction member '{}' -> '{}'.", (Object)memberId, (Object)res);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITransactionMember[] getMembers() {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            return this.getMembersNoLocking();
        }
    }

    private ITransactionMember[] getMembersNoLocking() {
        return this.m_memberMap.values().toArray(new ITransactionMember[this.m_memberMap.size()]);
    }

    @Override
    public void unregisterMember(ITransactionMember member) {
        if (member == null) {
            return;
        }
        this.unregisterMember(member.getMemberId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMember(String memberId) {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            this.m_memberMap.remove(memberId);
            if (LOG.isDebugEnabled()) {
                LOG.debug("unregister transaction member '{}'.", (Object)memberId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitPhase1() {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            if (this.m_cancelled) {
                throw new FutureCancelledError("Transaction cancelled", new Object[0]);
            }
            this.m_commitPhase = true;
        }
        ITransactionMember[] iTransactionMemberArray = this.getMembers();
        int n = iTransactionMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITransactionMember mem = iTransactionMemberArray[n2];
            if (mem.needsCommit()) {
                LOG.debug("commit phase 1 of transaction member '{}'.", (Object)mem.getMemberId());
                if (!mem.commitPhase1()) {
                    LOG.error("commit phase 1 failed for transaction member '{}'.", (Object)mem.getMemberId());
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void commitPhase2() {
        ITransactionMember[] iTransactionMemberArray = this.getMembers();
        int n = iTransactionMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITransactionMember mem = iTransactionMemberArray[n2];
            try {
                if (mem.needsCommit()) {
                    LOG.debug("commit phase 2 of transaction member '{}'.", (Object)mem);
                    mem.commitPhase2();
                }
            }
            catch (Throwable t) {
                this.addFailure(t);
                LOG.error("commit phase 2 failed for transaction member '{}'.", (Object)mem.getMemberId(), (Object)t);
            }
            ++n2;
        }
    }

    @Override
    public void rollback() {
        ITransactionMember[] iTransactionMemberArray = this.getMembers();
        int n = iTransactionMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITransactionMember mem = iTransactionMemberArray[n2];
            try {
                if (mem.needsCommit()) {
                    LOG.debug("rollback of transaction membmer '{}'.", (Object)mem);
                    mem.rollback();
                }
            }
            catch (Throwable t) {
                this.addFailure(t);
                LOG.error("rollback failed for transaction member '{}'.", (Object)mem.getMemberId(), (Object)t);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        ITransactionMember[] a;
        Object object = this.m_memberMapLock;
        synchronized (object) {
            a = this.getMembersNoLocking();
            this.m_memberMap.clear();
        }
        ITransactionMember[] iTransactionMemberArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            ITransactionMember mem = iTransactionMemberArray[n2];
            try {
                LOG.debug("release of transaction member '{}'. " + mem);
                mem.release();
            }
            catch (Throwable t) {
                LOG.error("release member {}", (Object)mem, (Object)t);
            }
            ++n2;
        }
    }

    @Override
    public boolean hasFailures() {
        return !this.m_failures.isEmpty();
    }

    @Override
    public Throwable[] getFailures() {
        return this.m_failures.toArray(new Throwable[this.m_failures.size()]);
    }

    @Override
    public void addFailure(Throwable t) {
        if (!this.m_failures.contains(t)) {
            this.m_failures.add(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            block9: {
                block8: {
                    if (!this.m_commitPhase) break block8;
                    return false;
                }
                if (!this.m_cancelled) break block9;
                return true;
            }
            this.m_cancelled = true;
            this.addFailure(new FutureCancelledError("Transaction cancelled", new Object[0]));
        }
        ITransactionMember[] iTransactionMemberArray = this.getMembers();
        int n = iTransactionMemberArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITransactionMember mem = iTransactionMemberArray[n2];
            try {
                mem.cancel();
            }
            catch (Throwable t) {
                LOG.error("cancel member {}", (Object)mem, (Object)t);
            }
            ++n2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.m_memberMapLock;
        synchronized (object) {
            return this.m_cancelled;
        }
    }
}

