/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Set;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.security.EncryptionKey;
import org.eclipse.scout.rt.platform.security.ISecurityProvider;
import org.eclipse.scout.rt.platform.security.KeyPairBytes;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.Base64Utility;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.StringUtility;

public final class SecurityUtility {
    private static final int DEFAULT_RANDOM_SIZE = 32;
    private static final LazyValue<ISecurityProvider> SECURITY_PROVIDER = new LazyValue<ISecurityProvider>(ISecurityProvider.class);

    private SecurityUtility() {
    }

    public static void encrypt(InputStream clearTextData, OutputStream encryptedData, EncryptionKey key) {
        SECURITY_PROVIDER.get().encrypt(clearTextData, encryptedData, key);
    }

    public static void decrypt(InputStream encryptedData, OutputStream clearTextData, EncryptionKey key) {
        SECURITY_PROVIDER.get().decrypt(encryptedData, clearTextData, key);
    }

    public static EncryptionKey createEncryptionKey(char[] password, byte[] salt, int keyLen) {
        return SECURITY_PROVIDER.get().createEncryptionKey(password, salt, keyLen);
    }

    public static byte[] encrypt(byte[] clearTextData, EncryptionKey key) {
        return SecurityUtility.doCrypt(clearTextData, key, true);
    }

    public static byte[] decrypt(byte[] encryptedData, EncryptionKey key) {
        return SecurityUtility.doCrypt(encryptedData, key, false);
    }

    public static byte[] encrypt(byte[] clearTextData, char[] password, byte[] salt, int keyLen) {
        return SecurityUtility.doCrypt(clearTextData, password, salt, keyLen, true);
    }

    public static byte[] decrypt(byte[] encryptedData, char[] password, byte[] salt, int keyLen) {
        return SecurityUtility.doCrypt(encryptedData, password, salt, keyLen, false);
    }

    static byte[] doCrypt(byte[] data, char[] password, byte[] salt, int keyLen, boolean encrypt) {
        EncryptionKey key = SecurityUtility.createEncryptionKey(password, salt, keyLen);
        return SecurityUtility.doCrypt(data, key, encrypt);
    }

    static byte[] doCrypt(byte[] data, EncryptionKey key, boolean encrypt) {
        Assertions.assertNotNull(data, "no data provided", new Object[0]);
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        int expectedOutSize = input.available();
        int aesBlockSize = 16;
        expectedOutSize = encrypt ? (expectedOutSize / aesBlockSize + 2) * aesBlockSize : (expectedOutSize -= 8);
        ByteArrayOutputStream result = new ByteArrayOutputStream(expectedOutSize);
        if (encrypt) {
            SecurityUtility.encrypt(input, result, key);
        } else {
            SecurityUtility.decrypt(input, result, key);
        }
        return result.toByteArray();
    }

    public static byte[] createRandomBytes(int numBytes) {
        return SECURITY_PROVIDER.get().createSecureRandomBytes(numBytes);
    }

    public static byte[] createRandomBytes() {
        return SecurityUtility.createRandomBytes(32);
    }

    public static SecureRandom createSecureRandom() {
        return SECURITY_PROVIDER.get().createSecureRandom();
    }

    public static byte[] hashPassword(char[] password, byte[] salt, int iterations) {
        return SECURITY_PROVIDER.get().createPasswordHash(password, salt, iterations);
    }

    public static byte[] hash(byte[] data, byte[] salt) {
        Assertions.assertNotNull(data, "no data provided", new Object[0]);
        return SecurityUtility.hash(new ByteArrayInputStream(data), salt);
    }

    public static byte[] hash(InputStream data, byte[] salt) {
        return SECURITY_PROVIDER.get().createHash(data, salt, 3557);
    }

    public static KeyPairBytes generateKeyPair() {
        return SECURITY_PROVIDER.get().createKeyPair();
    }

    public static byte[] createSignature(byte[] privateKey, InputStream data) {
        return SECURITY_PROVIDER.get().createSignature(privateKey, data);
    }

    public static byte[] createSignature(byte[] privateKey, byte[] data) {
        Assertions.assertNotNull(data, "no data provided", new Object[0]);
        return SecurityUtility.createSignature(privateKey, new ByteArrayInputStream(data));
    }

    public static boolean verifySignature(byte[] publicKey, InputStream data, byte[] signatureToVerify) {
        return SECURITY_PROVIDER.get().verifySignature(publicKey, data, signatureToVerify);
    }

    public static boolean verifySignature(byte[] publicKey, byte[] data, byte[] signatureToVerify) {
        Assertions.assertNotNull(data, "no data provided", new Object[0]);
        return SecurityUtility.verifySignature(publicKey, new ByteArrayInputStream(data), signatureToVerify);
    }

    public static byte[] createMac(byte[] password, InputStream data) {
        return SECURITY_PROVIDER.get().createMac(password, data);
    }

    public static byte[] createMac(byte[] password, byte[] data) {
        Assertions.assertNotNull(data, "no data provided", new Object[0]);
        return SecurityUtility.createMac(password, new ByteArrayInputStream(data));
    }

    public static String getPrincipalNames(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<Principal> principals = subject.getPrincipals();
        ArrayList<String> principalNames = new ArrayList<String>(principals.size());
        for (Principal principal : principals) {
            principalNames.add(principal.getName());
        }
        return StringUtility.join(", ", principalNames);
    }

    public static void main(String[] args) {
        KeyPairBytes keyPair = SecurityUtility.generateKeyPair();
        System.out.format("base64 encoded key pair:%n  private key: %s%n  public key:  %s%n", Base64Utility.encode(keyPair.getPrivateKey()), Base64Utility.encode(keyPair.getPublicKey()));
    }
}

