/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.security;

import java.nio.charset.StandardCharsets;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.security.EncryptionKey;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.Base64Utility;
import org.eclipse.scout.rt.platform.util.StringUtility;

@Bean
public class Crypter {
    protected static final String CURRENT_PROFILE = "0";
    private char[] m_password;
    private int m_keyLength;

    public Crypter init(char[] password, int keyLength) {
        Assertions.assertNotNull(password, "Password must not be null", new Object[0]);
        Assertions.assertNull(this.m_password, "Initialization can only be called once without prior reset", new Object[0]);
        this.m_password = password;
        this.m_keyLength = keyLength;
        return this;
    }

    public void reset() {
        if (this.m_password == null) {
            return;
        }
        int i = 0;
        while (i < this.m_password.length) {
            this.m_password[i] = '\u0000';
            ++i;
        }
        this.m_password = null;
    }

    protected char[] getPassword() {
        return this.m_password;
    }

    protected int getKeyLength() {
        return this.m_keyLength;
    }

    public String encrypt(String clearTextData) {
        return this.encrypt(clearTextData, false);
    }

    public String encryptUrlSafe(String clearTextData) {
        return this.encrypt(clearTextData, true);
    }

    protected String encrypt(String clearTextData, boolean urlSafe) {
        Assertions.assertNotNull(this.getPassword(), "Crypter was not initialized", new Object[0]);
        if (StringUtility.isNullOrEmpty(clearTextData)) {
            return null;
        }
        byte[] salt = SecurityUtility.createRandomBytes();
        EncryptionKey encryptionKey = SecurityUtility.createEncryptionKey(this.getPassword(), salt, this.getKeyLength());
        byte[] encryption = SecurityUtility.encrypt(clearTextData.getBytes(StandardCharsets.UTF_8), encryptionKey);
        return StringUtility.join(".", CURRENT_PROFILE, Base64Utility.encode(salt, urlSafe), Base64Utility.encode(encryption, urlSafe));
    }

    public String decrypt(String encryptedData) {
        return this.decrypt(encryptedData, false);
    }

    public String decryptUrlSafe(String encryptedData) {
        return this.decrypt(encryptedData, true);
    }

    protected String decrypt(String encryptedData, boolean urlSafe) {
        Assertions.assertNotNull(this.getPassword(), "Crypter was not initialized", new Object[0]);
        if (StringUtility.isNullOrEmpty(encryptedData)) {
            return null;
        }
        String[] encryptedDataParts = encryptedData.split("\\.", 3);
        if (encryptedDataParts.length != 3) {
            throw new ProcessingException("Format of encrypted data is invalid (part separation missing)", new Object[0]);
        }
        if (StringUtility.isNullOrEmpty(encryptedDataParts[0]) || StringUtility.isNullOrEmpty(encryptedDataParts[1]) || StringUtility.isNullOrEmpty(encryptedDataParts[2])) {
            throw new ProcessingException("Format of encrypted data is invalid (empty parts)", new Object[0]);
        }
        String profile = encryptedDataParts[0];
        byte[] salt = Base64Utility.decode(encryptedDataParts[1], urlSafe);
        byte[] encrypted = Base64Utility.decode(encryptedDataParts[2], urlSafe);
        if (!CURRENT_PROFILE.equals(profile)) {
            throw new ProcessingException("Encrypted data uses unsupported profile '{}'", profile);
        }
        EncryptionKey encryptionKey = SecurityUtility.createEncryptionKey(this.getPassword(), salt, this.getKeyLength());
        byte[] decrypted = SecurityUtility.decrypt(encrypted, encryptionKey);
        return new String(decrypted, StandardCharsets.UTF_8);
    }
}

