/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.resource;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.zip.Adler32;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.resource.MimeType;
import org.eclipse.scout.rt.platform.util.FileUtility;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

public final class BinaryResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String m_filename;
    private final String m_contentType;
    private final String m_charset;
    private final byte[] m_content;
    private final long m_lastModified;
    private final long m_fingerprint;
    private final boolean m_cachingAllowed;
    private final int m_cacheMaxAge;

    BinaryResource(String filename, String contentType, String charset, byte[] content, long lastModified, boolean cachingAllowed, int cacheMaxAge) {
        this.m_filename = filename;
        if (contentType == null) {
            if (filename != null) {
                contentType = FileUtility.getMimeType(filename);
            } else if (content != null && content.length > 0) {
                File f = IOUtility.createTempFile(null, content);
                contentType = FileUtility.getMimeType(f.toPath());
                f.delete();
            } else {
                contentType = MimeType.APPLICATION_OCTET_STREAM.getType();
            }
        }
        this.m_contentType = contentType;
        this.m_charset = charset;
        this.m_content = content;
        this.m_lastModified = lastModified;
        if (content != null) {
            Adler32 a = new Adler32();
            a.update(content);
            this.m_fingerprint = a.getValue();
        } else {
            this.m_fingerprint = -1L;
        }
        this.m_cachingAllowed = cachingAllowed;
        this.m_cacheMaxAge = cacheMaxAge;
    }

    public BinaryResource(String filename, byte[] content) {
        this(filename, null, null, content, -1L, false, 0);
    }

    public boolean hasFilename() {
        return StringUtility.hasText(this.getFilename());
    }

    public String getFilename() {
        return this.m_filename;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public String getCharset() {
        return this.m_charset;
    }

    public byte[] getContent() {
        return this.m_content;
    }

    public String getContentAsString() {
        Charset charset = StandardCharsets.UTF_8;
        if (this.getCharset() != null) {
            charset = Charset.forName(this.getCharset());
        }
        return new String(this.m_content, charset);
    }

    public int getContentLength() {
        return this.m_content != null ? this.m_content.length : -1;
    }

    public long getLastModified() {
        return this.m_lastModified;
    }

    public long getFingerprint() {
        return this.m_fingerprint;
    }

    public String getFingerprintAsHexString() {
        return Long.toHexString(this.m_fingerprint);
    }

    public boolean isCachingAllowed() {
        return this.m_cachingAllowed;
    }

    public int getCacheMaxAge() {
        return this.m_cacheMaxAge;
    }

    public BinaryResource createAlias(String newName) {
        return BinaryResources.create(this).withFilename(newName).build();
    }

    public BinaryResource createAliasWithSameExtension(String newNameWithoutExtension) {
        String fileExtension = FileUtility.getFileExtension(this.m_filename);
        String newName = String.valueOf(newNameWithoutExtension) + (fileExtension == null ? "" : "." + fileExtension);
        return this.createAlias(newName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)this.m_lastModified;
        result = 31 * result + (this.m_content == null ? 0 : this.m_content.length);
        result = 31 * result + (this.m_filename == null ? 0 : this.m_filename.hashCode());
        result = 31 * result + (this.m_contentType == null ? 0 : this.m_contentType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryResource other = (BinaryResource)obj;
        return this.m_lastModified == other.m_lastModified && ObjectUtility.equals(this.m_filename, other.m_filename) && ObjectUtility.equals(this.m_contentType, other.m_contentType) && Arrays.equals(this.m_content, other.m_content);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(", content: ");
        if (this.m_content == null) {
            sb.append("null");
        } else {
            sb.append(this.m_content.length).append(" bytes");
        }
        if (this.m_filename != null) {
            sb.append(", filename: ").append(this.m_filename);
        }
        if (this.m_contentType != null) {
            sb.append(", contentType: ").append(this.m_contentType);
        }
        if (this.m_charset != null) {
            sb.append(", charset: ").append(this.m_charset);
        }
        if (this.m_lastModified != -1L) {
            sb.append(", lastModified: ").append(this.m_lastModified);
        }
        if (this.m_fingerprint != -1L) {
            sb.append(", fingerprint: ").append(this.m_fingerprint);
        }
        sb.append("]");
        return sb.toString();
    }
}

