/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.reflect;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.platform.events.IListenerListWithManagement;
import org.eclipse.scout.rt.platform.events.ISnapshotCollector;
import org.eclipse.scout.rt.platform.events.ListenerListRegistry;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.WeakEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPropertySupport
implements IListenerListWithManagement {
    private static final Logger LOG = LoggerFactory.getLogger(BasicPropertySupport.class);
    public static final byte DEFAULT_BYTE_VALUE = 0;
    public static final int DEFAULT_INT_VALUE = 0;
    public static final int DEFAULT_DOUBLE_VALUE = 0;
    public static final Byte DEFAULT_BYTE = 0;
    public static final Integer DEFAULT_INT = 0;
    public static final Double DEFAULT_DOUBLE = 0.0;
    public static final long DEFAULT_LONG_VALUE = 0L;
    public static final Long DEFAULT_LONG = 0L;
    private static final Boolean DEFAULT_BOOL = Boolean.FALSE;
    private final Map<String, Object> m_props = new HashMap<String, Object>();
    private final Object m_source;
    private final Object m_listenerLock = new Object();
    private List<Object> m_listeners;
    private Map<String, List<Object>> m_childListeners;
    private int m_propertiesChanging;
    private List<PropertyChangeEvent> m_propertyEventBuffer;

    public BasicPropertySupport(Object sourceBean) {
        this.m_source = sourceBean;
        ListenerListRegistry.globalInstance().registerAsWeakReference(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSnapshot(ISnapshotCollector snapshot) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (this.m_listeners != null) {
                for (Object object2 : this.m_listeners) {
                    if (object2 instanceof WeakReference) {
                        snapshot.add(null, ((Reference)object2).get());
                        continue;
                    }
                    snapshot.add(null, object2);
                }
            }
            if (this.m_childListeners != null) {
                for (Map.Entry entry : this.m_childListeners.entrySet()) {
                    String context = (String)entry.getKey();
                    for (Object o : (List)entry.getValue()) {
                        if (o instanceof WeakReference) {
                            snapshot.add(context, ((Reference)o).get());
                            continue;
                        }
                        snapshot.add(context, o);
                    }
                }
            }
        }
    }

    public boolean isPropertiesChanging() {
        return this.m_propertiesChanging > 0;
    }

    public void setPropertiesChanging(boolean b) {
        if (b) {
            ++this.m_propertiesChanging;
        } else if (this.m_propertiesChanging > 0) {
            --this.m_propertiesChanging;
            if (this.m_propertiesChanging == 0) {
                this.processChangeBuffer();
            }
        }
    }

    public void clearProperties() {
        this.m_props.clear();
    }

    public Map<String, Object> getPropertiesMap() {
        int i = 0;
        while (i < 10) {
            try {
                return CollectionUtility.copyMap(this.m_props);
            }
            catch (ConcurrentModificationException cme) {
                LOG.debug("Could not create copy of properties map", (Throwable)cme);
                ++i;
            }
        }
        return CollectionUtility.copyMap(this.m_props);
    }

    public void putPropertiesMap(Map<String, Object> map) {
        this.m_props.putAll(map);
    }

    public boolean hasProperty(String name) {
        return this.m_props.containsKey(name);
    }

    public boolean setPropertyByte(String name, byte b) {
        return this.setProperty(name, b, DEFAULT_BYTE);
    }

    public byte getPropertyByte(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.byteValue() : (byte)0;
    }

    public boolean setPropertyInt(String name, int i) {
        return this.setProperty(name, i, DEFAULT_INT);
    }

    public int getPropertyInt(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.intValue() : 0;
    }

    public boolean setPropertyDouble(String name, double d) {
        return this.setProperty(name, d, DEFAULT_DOUBLE);
    }

    public double getPropertyDouble(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.doubleValue() : 0.0;
    }

    public boolean setPropertyLong(String name, long i) {
        return this.setProperty(name, i, DEFAULT_LONG);
    }

    public long getPropertyLong(String name) {
        Number n = (Number)this.getProperty(name);
        return n != null ? n.longValue() : DEFAULT_LONG.longValue();
    }

    public boolean setPropertyBool(String name, boolean b) {
        return this.setProperty(name, b, DEFAULT_BOOL);
    }

    public boolean getPropertyBool(String name) {
        Boolean b = (Boolean)this.getProperty(name);
        return b != null ? b.booleanValue() : DEFAULT_BOOL.booleanValue();
    }

    public boolean setPropertyString(String name, String s) {
        return this.setProperty(name, s);
    }

    public void setPropertyStringAlwaysFire(String name, String s) {
        this.setPropertyAlwaysFire(name, s);
    }

    public String getPropertyString(String name) {
        String s = (String)this.getProperty(name);
        return s;
    }

    public Object getProperty(String name) {
        return this.m_props.get(name);
    }

    public <T> boolean setPropertyList(String name, List<T> newValue) {
        return this.setPropertyList(name, newValue, false);
    }

    public <T> boolean setPropertyListAlwaysFire(String name, List<T> newValue) {
        return this.setPropertyList(name, newValue, true);
    }

    private <T> boolean setPropertyList(String name, List<T> newValue, boolean alwaysFire) {
        Object oldValue = this.m_props.get(name);
        boolean propChanged = this.setPropertyNoFire(name, newValue);
        if (propChanged || alwaysFire) {
            ArrayList eventOldValue = null;
            if (oldValue instanceof List) {
                eventOldValue = CollectionUtility.arrayList((Collection)oldValue);
            }
            ArrayList<T> eventNewValue = null;
            if (newValue != null) {
                eventNewValue = CollectionUtility.arrayList(newValue);
            }
            this.firePropertyChangeImpl(name, eventOldValue, eventNewValue);
            return propChanged;
        }
        return false;
    }

    public <T> List<T> getPropertyList(String name) {
        return (List)this.m_props.get(name);
    }

    public <T> boolean setPropertySet(String name, Set<T> newValue) {
        return this.setPropertySet(name, newValue, false);
    }

    public <T> boolean setPropertySetAlwaysFire(String name, Set<T> newValue) {
        return this.setPropertySet(name, newValue, true);
    }

    private <T> boolean setPropertySet(String name, Set<T> newValue, boolean alwaysFire) {
        Object oldValue = this.m_props.get(name);
        boolean propChanged = this.setPropertyNoFire(name, newValue);
        if (propChanged || alwaysFire) {
            HashSet<Collection> eventOldValue = null;
            if (oldValue instanceof Set) {
                eventOldValue = CollectionUtility.hashSet((Collection)oldValue);
            }
            HashSet<Set<T>> eventNewValue = null;
            if (newValue != null) {
                eventNewValue = CollectionUtility.hashSet(newValue);
            }
            this.firePropertyChangeImpl(name, eventOldValue, eventNewValue);
            return propChanged;
        }
        return false;
    }

    public <T> Set<T> getPropertySet(String name) {
        return (Set)this.m_props.get(name);
    }

    public boolean setProperty(String name, Object newValue) {
        return this.setProperty(name, newValue, null);
    }

    public boolean setPropertyNoFire(String name, Object newValue) {
        Object oldValue = this.m_props.get(name);
        this.m_props.put(name, newValue);
        return ObjectUtility.notEquals(oldValue, newValue);
    }

    public boolean setProperty(String name, Object newValue, Object defaultOldValueWhenNull) {
        Object oldValue = this.m_props.get(name);
        if (oldValue == null) {
            oldValue = defaultOldValueWhenNull;
        }
        this.m_props.put(name, newValue);
        if (ObjectUtility.equals(oldValue, newValue)) {
            return false;
        }
        this.firePropertyChangeImpl(name, oldValue, newValue);
        return true;
    }

    public void setPropertyAlwaysFire(String name, Object newValue) {
        Object oldValue = this.m_props.get(name);
        this.m_props.put(name, newValue);
        this.firePropertyChangeImpl(name, oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.addPropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            Object object = this.m_listenerLock;
            synchronized (object) {
                if (this.m_listeners == null) {
                    this.m_listeners = new ArrayList<Object>();
                }
                if (listener instanceof WeakEventListener) {
                    this.m_listeners.add(new WeakReference<PropertyChangeListener>(listener));
                } else {
                    this.m_listeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener instanceof PropertyChangeListenerProxy) {
            PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
            this.removePropertyChangeListener(proxy.getPropertyName(), (PropertyChangeListener)proxy.getListener());
        } else {
            Object object = this.m_listenerLock;
            synchronized (object) {
                this.removeFromListNoLock(this.m_listeners, listener);
                if (this.m_childListeners != null) {
                    for (List<Object> childList : this.m_childListeners.values()) {
                        this.removeFromListNoLock(childList, listener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (this.m_childListeners == null) {
                this.m_childListeners = new HashMap<String, List<Object>>();
            }
            List children = this.m_childListeners.computeIfAbsent(propertyName, k -> new ArrayList());
            if (listener instanceof WeakEventListener) {
                children.add(new WeakReference<PropertyChangeListener>(listener));
            } else {
                children.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            List<Object> childList;
            if (this.m_childListeners != null && (childList = this.m_childListeners.get(propertyName)) != null) {
                this.removeFromListNoLock(childList, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PropertyChangeListener> getPropertyChangeListeners() {
        ArrayList<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>(4);
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (this.m_listeners != null) {
                for (Object o : this.m_listeners) {
                    if (o instanceof WeakReference) {
                        o = ((Reference)o).get();
                    }
                    if (o == null) continue;
                    listeners.add((PropertyChangeListener)o);
                }
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<PropertyChangeListener>> getSpecificPropertyChangeListeners() {
        HashMap<String, List<PropertyChangeListener>> listeners = new HashMap<String, List<PropertyChangeListener>>();
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (this.m_childListeners != null) {
                for (Map.Entry<String, List<Object>> entry : this.m_childListeners.entrySet()) {
                    String propertyName = entry.getKey();
                    List<Object> propertySpecificListeners = entry.getValue();
                    if (propertySpecificListeners == null) continue;
                    for (Object o : propertySpecificListeners) {
                        if (o instanceof WeakReference) {
                            o = ((Reference)o).get();
                        }
                        if (o == null) continue;
                        List children = listeners.computeIfAbsent(propertyName, k -> new ArrayList());
                        children.add((PropertyChangeListener)o);
                    }
                }
            }
        }
        return listeners;
    }

    private void removeFromListNoLock(List listeners, PropertyChangeListener listener) {
        if (listeners == null) {
            return;
        }
        if (listener instanceof WeakEventListener) {
            int i = 0;
            int n = listeners.size();
            while (i < n) {
                Object o = listeners.get(i);
                if (o instanceof WeakReference && ((Reference)o).get() == listener) {
                    listeners.remove(i);
                    break;
                }
                ++i;
            }
        } else {
            listeners.remove(listener);
        }
        if (listeners.isEmpty() && listeners instanceof ArrayList) {
            ((ArrayList)listeners).trimToSize();
        }
    }

    public void firePropertyChange(PropertyChangeEvent e) {
        this.firePropertyChangeImpl(e);
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (ObjectUtility.equals(oldValue, newValue)) {
            return;
        }
        this.firePropertyChangeImpl(propertyName, oldValue, newValue);
    }

    private void firePropertyChangeImpl(String propertyName, Object oldValue, Object newValue) {
        List<Object> l = this.m_listeners;
        Map<String, List<Object>> m = this.m_childListeners;
        if (l != null && !l.isEmpty() || m != null && !m.isEmpty()) {
            PropertyChangeEvent e = new PropertyChangeEvent(this.m_source, propertyName, oldValue, newValue);
            this.firePropertyChangeImpl(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangeImpl(PropertyChangeEvent e) {
        if (e == null) {
            return;
        }
        if (this.isPropertiesChanging()) {
            Object object = this.m_listenerLock;
            synchronized (object) {
                if (this.m_propertyEventBuffer == null) {
                    this.m_propertyEventBuffer = new ArrayList<PropertyChangeEvent>();
                }
                this.m_propertyEventBuffer.add(e);
            }
        }
        ArrayList<PropertyChangeListener> targets = new ArrayList<PropertyChangeListener>(4);
        Object object = this.m_listenerLock;
        synchronized (object) {
            List<Object> childListeners;
            String propertyName;
            if (this.m_listeners != null) {
                for (Object o : this.m_listeners) {
                    if (o instanceof WeakReference) {
                        o = ((Reference)o).get();
                    }
                    if (o == null) continue;
                    targets.add((PropertyChangeListener)o);
                }
            }
            if ((propertyName = e.getPropertyName()) != null && this.m_childListeners != null && (childListeners = this.m_childListeners.get(propertyName)) != null) {
                for (Object o : childListeners) {
                    if (o instanceof WeakReference) {
                        o = ((Reference)o).get();
                    }
                    if (o == null) continue;
                    targets.add((PropertyChangeListener)o);
                }
            }
        }
        if (!targets.isEmpty()) {
            for (PropertyChangeListener listener : targets) {
                listener.propertyChange(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChangeBuffer() {
        PropertyChangeEvent[] a = null;
        Object object = this.m_listenerLock;
        synchronized (object) {
            if (this.m_propertyEventBuffer != null) {
                a = this.m_propertyEventBuffer.toArray(new PropertyChangeEvent[this.m_propertyEventBuffer.size()]);
            }
            this.m_propertyEventBuffer = null;
        }
        if (a != null && a.length > 0) {
            LinkedList<PropertyChangeEvent> coalesceList = new LinkedList<PropertyChangeEvent>();
            HashSet<String> names = new HashSet<String>();
            int i = a.length - 1;
            while (i >= 0) {
                if (!names.contains(a[i].getPropertyName())) {
                    coalesceList.add(0, a[i]);
                    names.add(a[i].getPropertyName());
                }
                --i;
            }
            for (PropertyChangeEvent e : coalesceList) {
                this.firePropertyChangeImpl(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String propertyName) {
        Object object = this.m_listenerLock;
        synchronized (object) {
            block5: {
                ArrayList<PropertyChangeListener> generalListeners = this.getPropertyChangeListeners();
                if (!CollectionUtility.hasElements(generalListeners)) break block5;
                return true;
            }
            List<PropertyChangeListener> specificListeners = null;
            if (propertyName != null && this.m_childListeners != null) {
                specificListeners = this.getSpecificPropertyChangeListeners().get(propertyName);
            }
            return CollectionUtility.hasElements(specificListeners);
        }
    }
}

