/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.nls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.nls.NlsResourceBundle;
import org.eclipse.scout.rt.platform.nls.NlsResourceBundleCache;
import org.eclipse.scout.rt.platform.nls.NlsUtility;

public class DynamicNls {
    private final List<NlsResourceBundleCache> m_resourceBundles = new ArrayList<NlsResourceBundleCache>();

    public void registerResourceBundle(String resourceBundleName, Class<?> wrapperClass) {
        this.m_resourceBundles.add(0, new NlsResourceBundleCache(resourceBundleName, wrapperClass));
    }

    public final String getText(String key, String ... messageArguments) {
        return this.getText((Locale)null, key, messageArguments);
    }

    public final String getText(Locale locale, String key, String ... messageArguments) {
        if (key == null) {
            return null;
        }
        String text = this.getTextInternal(locale, key);
        return NlsUtility.bindText(text, messageArguments);
    }

    private String getTextInternal(Locale locale, String key) {
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        for (NlsResourceBundleCache c : this.m_resourceBundles) {
            String result;
            NlsResourceBundle resourceBundle = c.getResourceBundle(locale);
            if (resourceBundle == null || (result = resourceBundle.getText(key)) == null) continue;
            return result;
        }
        return null;
    }

    public Map<String, String> getTextMap(Locale locale) {
        if (locale == null) {
            locale = this.getDefaultLocale();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (NlsResourceBundleCache c : this.m_resourceBundles) {
            NlsResourceBundle resourceBundle = c.getResourceBundle(locale);
            if (resourceBundle == null) continue;
            resourceBundle.collectTextMapping(map::putIfAbsent);
        }
        return map;
    }

    protected Locale getDefaultLocale() {
        return NlsLocale.get();
    }
}

