/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.logger;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.scout.rt.platform.logger.AbstractLoggerSupport;
import org.eclipse.scout.rt.platform.logger.ILoggerSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullLoggerSupport
extends AbstractLoggerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NullLoggerSupport.class);
    private static final Object PRESENT = new Object();
    private final ConcurrentMap<String, Object> m_queriedLoggers = new ConcurrentHashMap<String, Object>();
    private final String m_slf4jloggerFactoryClassStr;

    public NullLoggerSupport(String slf4jloggerFactoryClassStr) {
        this.m_slf4jloggerFactoryClassStr = slf4jloggerFactoryClassStr;
    }

    protected ConcurrentMap<String, Object> getQueriedLoggers() {
        return this.m_queriedLoggers;
    }

    protected String getSlf4jloggerFactoryClassStr() {
        return this.m_slf4jloggerFactoryClassStr;
    }

    @Override
    public ILoggerSupport.LogLevel getLogLevel(String name) {
        this.logLoggerSupportNotAvailable(name);
        return null;
    }

    @Override
    public void setLogLevel(String name, ILoggerSupport.LogLevel level) {
        this.logLoggerSupportNotAvailable(name);
    }

    private void logLoggerSupportNotAvailable(String name) {
        if (LOG.isInfoEnabled() && this.getQueriedLoggers().putIfAbsent(name, PRESENT) == null) {
            LOG.info("getting or setting log level is not supported by current slf4j logging implementation [logger={}, slf4jLoggerFactoryClassStr={}]", (Object)name, (Object)this.getSlf4jloggerFactoryClassStr());
        }
    }
}

