/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.job.internal;

import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.job.listener.IJobListener;
import org.eclipse.scout.rt.platform.job.listener.JobEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobListenerWithFilter
implements IJobListener {
    private static final Logger LOG = LoggerFactory.getLogger(JobListenerWithFilter.class);
    private final IJobListener m_listener;
    private final Predicate<JobEvent> m_filter;

    JobListenerWithFilter(IJobListener listener, Predicate<JobEvent> filter) {
        this.m_listener = listener;
        this.m_filter = filter;
    }

    @Override
    public void changed(JobEvent event) {
        if (this.m_filter == null || this.m_filter.test(event)) {
            try {
                this.m_listener.changed(event);
            }
            catch (RuntimeException e) {
                LOG.error("Listener or filter threw exception while accepting or handling job lifecycle event [listener={}, filter={}, event={}]", new Object[]{this.m_listener.getClass().getName(), this.m_filter == null ? "null" : this.m_filter.getClass().getName(), event, e});
            }
        }
    }

    public IJobListener getListener() {
        return this.m_listener;
    }

    public Predicate<JobEvent> getFilter() {
        return this.m_filter;
    }
}

