/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.exception;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.IExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class PlatformExceptionTranslator
implements IExceptionTranslator<PlatformException> {
    @Override
    public PlatformException translate(Throwable throwable) {
        Throwable eUnwrapped = BEANS.get(DefaultExceptionTranslator.class).unwrap(throwable);
        PlatformException eTranslated = this.translateInternal(eUnwrapped);
        PlatformException eDecorated = BEANS.get(DefaultExceptionTranslator.class).decorate(eTranslated);
        return eDecorated;
    }

    protected PlatformException translateInternal(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof PlatformException) {
            return (PlatformException)t;
        }
        return new PlatformException(ObjectUtility.nvl(t.getMessage(), t.getClass().getSimpleName()), new Object[]{t}).withContextInfo("translator", PlatformExceptionTranslator.class.getName(), new Object[0]);
    }
}

