/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.events;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.scout.rt.platform.events.IListenerListWithManagement;
import org.eclipse.scout.rt.platform.events.ListenerListSnapshot;

public final class ListenerListRegistry {
    private static ListenerListRegistry globalInstance = new ListenerListRegistry();
    private final Map<IListenerListWithManagement, Object> m_set = new WeakHashMap<IListenerListWithManagement, Object>();

    public static ListenerListRegistry globalInstance() {
        return globalInstance;
    }

    static void setGlobalInstance(ListenerListRegistry newInstance) {
        globalInstance = newInstance;
    }

    ListenerListRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsWeakReference(IListenerListWithManagement eventListenerList) {
        Map<IListenerListWithManagement, Object> map = this.m_set;
        synchronized (map) {
            this.m_set.put(eventListenerList, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenerListCount() {
        Map<IListenerListWithManagement, Object> map = this.m_set;
        synchronized (map) {
            return this.m_set.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerListSnapshot createSnapshot() {
        ListenerListSnapshot snapshot = new ListenerListSnapshot();
        Map<IListenerListWithManagement, Object> map = this.m_set;
        synchronized (map) {
            for (IListenerListWithManagement list : this.m_set.keySet()) {
                if (list == null) continue;
                list.createSnapshot((context, listener) -> snapshot.add(list, context, listener));
            }
        }
        return snapshot;
    }
}

