/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.dataobject;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.dataobject.AttributeName;
import org.eclipse.scout.rt.platform.dataobject.DataObjectAttributeDescriptor;
import org.eclipse.scout.rt.platform.dataobject.DoList;
import org.eclipse.scout.rt.platform.dataobject.DoValue;
import org.eclipse.scout.rt.platform.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.dataobject.TypeName;
import org.eclipse.scout.rt.platform.dataobject.TypeVersion;
import org.eclipse.scout.rt.platform.dataobject.ValueFormat;
import org.eclipse.scout.rt.platform.inventory.ClassInventory;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DataObjectInventory {
    private static final Logger LOG = LoggerFactory.getLogger(DataObjectInventory.class);
    private final Map<String, Class<? extends IDoEntity>> m_typeNameToClassMap = new HashMap<String, Class<? extends IDoEntity>>();
    private final Map<Class<? extends IDoEntity>, String> m_classToTypeName = new HashMap<Class<? extends IDoEntity>, String>();
    private final Map<Class<? extends IDoEntity>, String> m_classToTypeVersion = new HashMap<Class<? extends IDoEntity>, String>();
    private final Map<Class<? extends IDoEntity>, Map<String, DataObjectAttributeDescriptor>> m_classAttributeMap = new ConcurrentHashMap<Class<? extends IDoEntity>, Map<String, DataObjectAttributeDescriptor>>();

    @PostConstruct
    protected void init() {
        ClassInventory.get().getKnownAnnotatedTypes(TypeName.class).stream().map(IClassInfo::resolveClass).forEach(c -> this.registerClassByTypeName((Class<?>)c));
        ClassInventory.get().getKnownAnnotatedTypes(TypeVersion.class).stream().map(IClassInfo::resolveClass).forEach(c -> this.registerClassByTypeVersion((Class<?>)c));
        LOG.info("Registry initialized, found {} {} implementations with @{} annotation and {} implementations with @{} annotation.", new Object[]{this.m_typeNameToClassMap.size(), IDoEntity.class.getSimpleName(), TypeName.class.getSimpleName(), this.m_classToTypeVersion.size(), TypeVersion.class.getSimpleName()});
    }

    public String toTypeName(Class<?> queryClazz) {
        Class<?> clazz = queryClazz;
        String name;
        while ((name = this.m_classToTypeName.get(clazz)) == null) {
            if (clazz == null || clazz == Object.class) {
                String defaultTypeName = this.getDefaultName(queryClazz);
                LOG.warn("Could not find type name for {}, using default value {}", queryClazz, (Object)defaultTypeName);
                return defaultTypeName;
            }
            clazz = clazz.getSuperclass();
        }
        return name;
    }

    public Class<? extends IDoEntity> fromTypeName(String typeName) {
        Class<? extends IDoEntity> rawClass = this.m_typeNameToClassMap.get(typeName);
        if (rawClass != null) {
            if (BEANS.getBeanManager().isBean(rawClass)) {
                IBean<? extends IDoEntity> bean = BEANS.getBeanManager().uniqueBean(rawClass);
                if (bean != null) {
                    return bean.getBeanClazz();
                }
                LOG.warn("Class lookup for raw class {} with type name {} is not unique, cannot lookup matching bean class!", rawClass, (Object)typeName);
            } else {
                return rawClass;
            }
        }
        return null;
    }

    public String getTypeVersion(Class<? extends IDoEntity> clazz) {
        return this.m_classToTypeVersion.get(clazz);
    }

    public Map<String, Class<? extends IDoEntity>> getTypeNameToClassMap() {
        return Collections.unmodifiableMap(this.m_typeNameToClassMap);
    }

    public Optional<DataObjectAttributeDescriptor> getAttributeDescription(Class<? extends IDoEntity> entityClass, String attributeName) {
        this.ensureEntityDefinitionLoaded(entityClass);
        return Optional.ofNullable(this.m_classAttributeMap.get(entityClass).get(attributeName));
    }

    public Map<String, DataObjectAttributeDescriptor> getAttributesDescription(Class<? extends IDoEntity> entityClass) {
        this.ensureEntityDefinitionLoaded(entityClass);
        return Collections.unmodifiableMap(this.m_classAttributeMap.get(entityClass));
    }

    protected void registerClassByTypeName(Class<?> clazz) {
        if (IDoEntity.class.isAssignableFrom(clazz)) {
            Class<IDoEntity> entityClass = clazz.asSubclass(IDoEntity.class);
            String name = this.resolveTypeName(clazz);
            String registeredName = this.m_classToTypeName.put(entityClass, name);
            Class<IDoEntity> registeredClass = this.m_typeNameToClassMap.put(name, entityClass);
            this.checkDuplicateClassMapping(clazz, name, registeredName, registeredClass);
            LOG.debug("Registered class {} with type name '{}'", entityClass, (Object)name);
        } else {
            LOG.warn("Class {} is annotated with @{} but is not an instance of {}, skip registration", new Object[]{clazz.getName(), TypeName.class.getSimpleName(), IDoEntity.class});
        }
    }

    protected void registerClassByTypeVersion(Class<?> clazz) {
        if (IDoEntity.class.isAssignableFrom(clazz)) {
            Class<IDoEntity> entityClass = clazz.asSubclass(IDoEntity.class);
            String version = this.resolveTypeVersion(clazz);
            if (version != null) {
                String registeredVersion = this.m_classToTypeVersion.put(entityClass, version);
                Assertions.assertNull(registeredVersion, "{} was already registered with type version {}, register each class only once.", clazz, registeredVersion, TypeVersion.class.getSimpleName());
            }
            LOG.debug("Registered class {} with type version '{}'", entityClass, (Object)version);
        } else {
            LOG.warn("Class {} is annotated with @{} but is not an instance of {}, skip registration", new Object[]{clazz.getName(), TypeVersion.class.getSimpleName(), IDoEntity.class});
        }
    }

    protected void checkDuplicateClassMapping(Class<?> clazz, String name, String existingName, Class<? extends IDoEntity> existingClass) {
        Assertions.assertNull(existingClass, "{} and {} have the same type '{}', use an unique @{} annotation value.", clazz, existingClass, name, TypeName.class.getSimpleName());
        Assertions.assertNull(existingName, "{} was already registered with type name {}, register each class only once.", clazz, existingName, TypeName.class.getSimpleName());
    }

    protected void ensureEntityDefinitionLoaded(Class<? extends IDoEntity> entityClass) {
        this.m_classAttributeMap.computeIfAbsent(entityClass, e -> this.createAllAttributes((Class<? extends IDoEntity>)e));
    }

    protected Map<String, DataObjectAttributeDescriptor> createAllAttributes(Class<? extends IDoEntity> entityClass) {
        LOG.debug("Adding attributes of class {} to registry.", entityClass);
        HashMap<String, DataObjectAttributeDescriptor> attributes = new HashMap<String, DataObjectAttributeDescriptor>();
        Method[] methodArray = entityClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterizedType pt;
            Type returnType;
            Method method = methodArray[n2];
            if (method.getParameterCount() == 0 && !Modifier.isStatic(method.getModifiers()) && (returnType = method.getGenericReturnType()) instanceof ParameterizedType && ObjectUtility.isOneOf((Object)(pt = (ParameterizedType)returnType).getRawType(), DoValue.class, DoList.class)) {
                this.addAttribute(attributes, pt, method);
            }
            ++n2;
        }
        return attributes;
    }

    protected void addAttribute(Map<String, DataObjectAttributeDescriptor> attributes, ParameterizedType type, Method accessor) {
        String name = this.resolveAttributeName(accessor);
        Optional<String> formatPattern = this.resolveAttributeFormat(accessor);
        attributes.put(name, new DataObjectAttributeDescriptor(name, type, formatPattern, accessor));
        LOG.debug("Adding attribute '{}' with type {} and format pattern '{}' to registry.", new Object[]{name, type, formatPattern.orElse("null")});
    }

    protected String resolveTypeName(Class<?> c) {
        TypeName typeNameAnn = c.getAnnotation(TypeName.class);
        if (typeNameAnn != null && StringUtility.hasText(typeNameAnn.value())) {
            return typeNameAnn.value();
        }
        return this.getDefaultName(c);
    }

    protected String getDefaultName(Class<?> c) {
        return c != null ? c.getSimpleName() : null;
    }

    protected String resolveTypeVersion(Class<?> c) {
        TypeVersion typeVersionAnn = c.getAnnotation(TypeVersion.class);
        if (typeVersionAnn != null && StringUtility.hasText(typeVersionAnn.value())) {
            return typeVersionAnn.value();
        }
        return null;
    }

    protected String resolveAttributeName(Method accessor) {
        if (accessor.isAnnotationPresent(AttributeName.class)) {
            return accessor.getAnnotation(AttributeName.class).value();
        }
        return accessor.getName();
    }

    protected Optional<String> resolveAttributeFormat(Method accessor) {
        if (accessor.isAnnotationPresent(ValueFormat.class)) {
            return Optional.ofNullable(accessor.getAnnotation(ValueFormat.class).pattern());
        }
        return Optional.empty();
    }
}

