/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.context;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.TypeParameterBeanRegistry;
import org.eclipse.scout.rt.platform.context.IRunContextChainInterceptorProducer;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;

@ApplicationScoped
public class RunContextChainIntercepterRegistry {
    private final TypeParameterBeanRegistry<IRunContextChainInterceptorProducer> m_runContextInterceptorProducers = new TypeParameterBeanRegistry<IRunContextChainInterceptorProducer>(IRunContextChainInterceptorProducer.class);
    private IRegistrationHandle m_registrationHandle;

    @PostConstruct
    protected void buildProducerLinking() {
        this.m_registrationHandle = this.m_runContextInterceptorProducers.registerBeans(BEANS.all(IRunContextChainInterceptorProducer.class));
    }

    public void reindex() {
        this.m_registrationHandle.dispose();
        this.buildProducerLinking();
    }

    public <T extends RunContext> List<IRunContextChainInterceptorProducer<T>> getRunContextInterceptorProducer(Class<?> runContextClass) {
        ArrayList<IRunContextChainInterceptorProducer<T>> result = new ArrayList<IRunContextChainInterceptorProducer<T>>();
        List<IRunContextChainInterceptorProducer> beans = this.m_runContextInterceptorProducers.getBeans(runContextClass);
        for (IRunContextChainInterceptorProducer iRunContextChainInterceptorProducer : beans) {
            result.add(iRunContextChainInterceptorProducer);
        }
        return result;
    }
}

