/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.context;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.scout.rt.platform.util.Assertions;

public class PropertyMap
implements Iterable<Map.Entry<Object, Object>> {
    public static final ThreadLocal<PropertyMap> CURRENT = new ThreadLocal();
    public static final String PROP_SERVER_SCOPE = "scout.scope.server";
    public static final String PROP_CLIENT_SCOPE = "scout.scope.client";
    private final Map<Object, Object> m_properties = new ConcurrentHashMap<Object, Object>();

    public PropertyMap() {
        this(null);
    }

    public PropertyMap(PropertyMap origin) {
        if (origin != null && !origin.m_properties.isEmpty()) {
            this.m_properties.putAll(origin.m_properties);
        }
    }

    public <VALUE> VALUE get(Object key) {
        Assertions.assertNotNull(key, "Key must not be null", new Object[0]);
        return (VALUE)this.m_properties.get(key);
    }

    public <VALUE> VALUE getOrDefault(Object key, VALUE defaultValue) {
        Assertions.assertNotNull(key, "Key must not be null", new Object[0]);
        if (this.m_properties.containsKey(key)) {
            return (VALUE)this.m_properties.get(key);
        }
        return defaultValue;
    }

    public void put(Object key, Object value) {
        Assertions.assertNotNull(key, "Key must not be null", new Object[0]);
        if (value == null) {
            this.m_properties.remove(key);
        } else {
            this.m_properties.put(key, value);
        }
    }

    public boolean contains(Object key) {
        Assertions.assertNotNull(key, "Key must not be null", new Object[0]);
        return this.m_properties.containsKey(key);
    }

    public void clear() {
        this.m_properties.clear();
    }

    @Override
    public Iterator<Map.Entry<Object, Object>> iterator() {
        return this.m_properties.entrySet().iterator();
    }

    public static boolean isSet(String property) {
        PropertyMap propertyMap = CURRENT.get();
        if (propertyMap == null) {
            return false;
        }
        return propertyMap.contains(property);
    }
}

