/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.config.DefaultConfigFileLoader;
import org.eclipse.scout.rt.platform.config.IConfigFileLoader;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesHelper {
    private static final char ENVIRONMENT_VARIABLE_DOT_REPLACEMENT = '_';
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");
    public static final String CLASSPATH_PROTOCOL_NAME = "classpath";
    public static final char PROTOCOL_DELIMITER = ':';
    public static final char NAMESPACE_DELIMITER = '|';
    public static final char COLLECTION_DELIMITER_START = '[';
    public static final char COLLECTION_DELIMITER_END = ']';
    public static final String CLASSPATH_PREFIX = "classpath:";
    public static final String IMPORT_KEY = "import";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesHelper.class);
    private final Map<String, String> m_configProperties = new HashMap<String, String>();
    private final boolean m_isInitialized;

    public PropertiesHelper(URL propertiesFileUrl) {
        this(propertiesFileUrl, PropertiesHelper.getSelfIgnore(propertiesFileUrl));
    }

    public PropertiesHelper(String name) {
        this(name, Collections.singleton(name));
    }

    protected PropertiesHelper(String fileName, Set<String> importsToIgnore) {
        this(PropertiesHelper.getPropertiesFileUrl(fileName), importsToIgnore);
    }

    protected PropertiesHelper(URL propertiesFileUrl, Set<String> importsToIgnore) {
        if (propertiesFileUrl != null) {
            this.parse(propertiesFileUrl);
            this.importAll(importsToIgnore, PLACEHOLDER_PATTERN);
            this.resolveAll(PLACEHOLDER_PATTERN);
            this.m_isInitialized = true;
        } else {
            this.m_isInitialized = false;
        }
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProperty(key, defaultValue, null);
    }

    public String getProperty(String key, String defaultValue, String namespace) {
        if (!StringUtility.hasText(key)) {
            return null;
        }
        String propKey = this.toPropertyKey(key, namespace).toString();
        String value = null;
        value = System.getProperty(propKey);
        if (StringUtility.hasText(value)) {
            return this.resolve(value, PLACEHOLDER_PATTERN);
        }
        String envValue = this.lookupEnvironmentVariableValue(propKey);
        if (StringUtility.hasText(envValue)) {
            return this.resolve(envValue, PLACEHOLDER_PATTERN);
        }
        value = this.m_configProperties.get(propKey);
        if (StringUtility.hasText(value)) {
            return value;
        }
        return defaultValue;
    }

    protected String lookupEnvironmentVariableValue(String propKey) {
        String value = this.getEnvironmentVariable(propKey);
        if (value != null) {
            return value;
        }
        String keyWithoutDots = propKey.replace('.', '_');
        value = this.getEnvironmentVariable(keyWithoutDots);
        if (value != null) {
            this.logInexactEnvNameMatch(propKey, keyWithoutDots);
            return value;
        }
        String uppercasedKey = propKey.toUpperCase();
        value = this.getEnvironmentVariable(uppercasedKey);
        if (value != null) {
            this.logInexactEnvNameMatch(propKey, uppercasedKey);
            return value;
        }
        String keyWithoutDotsUppercased = keyWithoutDots.toUpperCase();
        value = this.getEnvironmentVariable(keyWithoutDotsUppercased);
        if (value != null) {
            this.logInexactEnvNameMatch(propKey, keyWithoutDotsUppercased);
            return value;
        }
        return null;
    }

    protected String getEnvironmentVariable(String propKey) {
        return System.getenv(propKey);
    }

    protected void logInexactEnvNameMatch(String propKey, String actualEnvVariableName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Property '{}' resolved to environment variable '{}' by inexact match.", (Object)propKey, (Object)actualEnvVariableName);
        }
    }

    public List<String> getPropertyList(String key) {
        return this.getPropertyList(key, (String)null);
    }

    public List<String> getPropertyList(String key, String namespace) {
        return this.getPropertyList(key, Collections.emptyList(), namespace);
    }

    public List<String> getPropertyList(String key, List<String> defaultValue) {
        return this.getPropertyList(key, defaultValue, null);
    }

    public List<String> getPropertyList(String key, List<String> defaultValue, String namespace) {
        if (!StringUtility.hasText(key)) {
            return defaultValue;
        }
        Map<String, String> resultAsMap = this.getPropertyMap(key, null, namespace);
        if (resultAsMap == null) {
            String value = this.getProperty(key, null, namespace);
            if (StringUtility.hasText(value)) {
                return Collections.singletonList(value);
            }
            return defaultValue;
        }
        String[] result = new String[resultAsMap.size()];
        for (Map.Entry<String, String> entry : resultAsMap.entrySet()) {
            int index = this.toListIndex(entry.getKey(), key);
            if (index >= result.length) {
                throw this.newInvalidListIndexException(key, entry.getKey(), null);
            }
            result[index] = entry.getValue();
        }
        return Collections.unmodifiableList(Arrays.asList(result));
    }

    public Map<String, String> getPropertyMap(String key) {
        return this.getPropertyMap(key, (String)null);
    }

    public Map<String, String> getPropertyMap(String key, Map<String, String> defaultValue) {
        return this.getPropertyMap(key, defaultValue, null);
    }

    public Map<String, String> getPropertyMap(String key, String namespace) {
        return this.getPropertyMap(key, Collections.emptyMap(), namespace);
    }

    public Map<String, String> getPropertyMap(String key, Map<String, String> defaultValue, String namespace) {
        if (!StringUtility.hasText(key)) {
            return defaultValue;
        }
        String keyPrefix = this.toCollectionKeyPrefix(key, namespace).toString();
        HashMap<String, String> result = new HashMap<String, String>();
        this.collectMapEntriesWith(keyPrefix, System.getenv().keySet(), result);
        this.collectMapEntriesWith(keyPrefix, this.m_configProperties.keySet(), result);
        this.collectMapEntriesWith(keyPrefix, System.getProperties().keySet(), result);
        if (result.isEmpty()) {
            return defaultValue;
        }
        return Collections.unmodifiableMap(result);
    }

    public boolean getPropertyBoolean(String key, boolean defaultValue) {
        return this.getPropertyBoolean(key, defaultValue, null);
    }

    public boolean getPropertyBoolean(String key, boolean defaultValue, String namespace) {
        String rawValue = this.getProperty(key, namespace);
        if (rawValue == null) {
            return defaultValue;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(rawValue) || Boolean.FALSE.toString().equalsIgnoreCase(rawValue)) {
            return Boolean.parseBoolean(rawValue);
        }
        throw new IllegalArgumentException("Invalid boolean-value for property '" + key + "' configured: " + rawValue);
    }

    public int getPropertyInt(String key, int defaultValue) {
        return this.getPropertyInt(key, defaultValue, null);
    }

    public int getPropertyInt(String key, int defaultValue, String namespace) {
        String valueRaw = this.getProperty(key, namespace);
        if (valueRaw == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueRaw);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid int-value for property '" + key + "' configured: " + valueRaw, e);
        }
    }

    public long getPropertyLong(String key, long defaultValue) {
        return this.getPropertyLong(key, defaultValue, null);
    }

    public long getPropertyLong(String key, long defaultValue, String namespace) {
        String valueRaw = this.getProperty(key, namespace);
        if (valueRaw == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(valueRaw);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid long-value for property '" + key + "' configured: " + valueRaw, e);
        }
    }

    public float getPropertyFloat(String key, float defaultValue) {
        return this.getPropertyFloat(key, defaultValue, null);
    }

    public float getPropertyFloat(String key, float defaultValue, String namespace) {
        String valueRaw = this.getProperty(key, namespace);
        if (valueRaw == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(valueRaw);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid float-value for property '" + key + "' configured: " + valueRaw, e);
        }
    }

    public double getPropertyDouble(String key, double defaultValue) {
        return this.getPropertyDouble(key, defaultValue, null);
    }

    public double getPropertyDouble(String key, double defaultValue, String namespace) {
        String valueRaw = this.getProperty(key, namespace);
        if (valueRaw == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(valueRaw);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid double-value for property '" + key + "' configured: " + valueRaw, e);
        }
    }

    public Set<String> getAllPropertyNames() {
        return Collections.unmodifiableSet(this.m_configProperties.keySet());
    }

    public Map<String, String> getAllEntries() {
        return Collections.unmodifiableMap(this.m_configProperties);
    }

    public boolean hasProperty(String key) {
        return this.m_configProperties.containsKey(key);
    }

    public boolean isInitialized() {
        return this.m_isInitialized;
    }

    protected void collectMapEntriesWith(String keyPrefix, Set<?> keySet, Map<String, String> collector) {
        for (Object propKey : keySet) {
            String k = propKey.toString();
            String mapKey = this.toMapKey(k, keyPrefix);
            if (mapKey == null) continue;
            collector.put(mapKey, this.getProperty(k));
        }
    }

    protected int toListIndex(String mapKey, String requestedKey) {
        try {
            int i = Integer.parseInt(mapKey);
            if (i < 0) {
                throw this.newInvalidListIndexException(requestedKey, mapKey, null);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw this.newInvalidListIndexException(requestedKey, mapKey, e);
        }
    }

    protected IllegalArgumentException newInvalidListIndexException(String requestedKey, String mapKey, Throwable cause) {
        String fullKey = String.valueOf(requestedKey) + '[' + mapKey + ']';
        return new IllegalArgumentException("Invalid list index '" + mapKey + "' in key '" + fullKey + "'. List indices must be zero-based, continuous, positive numeric values.", cause);
    }

    protected String toMapKey(String propKey, String keyPrefix) {
        if (propKey.startsWith(keyPrefix) && propKey.charAt(propKey.length() - 1) == ']') {
            String mapKey = propKey.substring(keyPrefix.length(), propKey.length() - 1);
            if (StringUtility.hasText(mapKey)) {
                return mapKey;
            }
            throw new IllegalArgumentException("Invalid map property with key '" + propKey + "'.");
        }
        return null;
    }

    protected StringBuilder toCollectionKeyPrefix(String key, String namespace) {
        return this.toPropertyKey(key, namespace).append('[');
    }

    protected StringBuilder toPropertyKey(String key, String namespace) {
        StringBuilder propKey = new StringBuilder(StringUtility.length(namespace) + key.length() + 5);
        if (namespace != null) {
            propKey.append(namespace);
            propKey.append('|');
        }
        propKey.append(key);
        return propKey;
    }

    protected String resolve(String s, Pattern pat) {
        Matcher m = pat.matcher(s);
        boolean found = m.find();
        if (!found) {
            return s;
        }
        String t = s;
        LinkedHashSet loopDetection = new LinkedHashSet();
        while (found) {
            StringBuffer sb = new StringBuffer();
            ArrayList<String> stageKeys = new ArrayList<String>();
            while (found) {
                String key = m.group(1);
                String value = this.getProperty(key);
                if (!StringUtility.hasText(value)) {
                    throw new IllegalArgumentException("resolving expression '" + s + "': variable ${" + key + "} is not defined in the context.");
                }
                if (value.contains(s)) {
                    throw new IllegalArgumentException("resolving expression '" + s + "': loop detected (the resolved value contains the original expression): " + value);
                }
                m.appendReplacement(sb, Matcher.quoteReplacement(value));
                stageKeys.add(key);
                if (loopDetection.contains(key)) {
                    throw new IllegalArgumentException("resolving expression '" + s + "': loop detected: " + loopDetection);
                }
                found = m.find();
            }
            m.appendTail(sb);
            loopDetection.addAll(stageKeys);
            t = sb.toString();
            m = pat.matcher(t);
            found = m.find();
        }
        return t;
    }

    protected static Set<String> getSelfIgnore(URL url) {
        if (url == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(url.toExternalForm());
    }

    protected static URL getPropertiesFileUrl(String filePath) {
        if (!StringUtility.hasText(filePath)) {
            return null;
        }
        String sysPropFileName = System.getProperty(filePath);
        if (StringUtility.hasText(sysPropFileName)) {
            filePath = sysPropFileName;
        }
        return PropertiesHelper.getResourceUrl(filePath);
    }

    public static URL getResourceUrl(String filePath) {
        boolean isClasspathUrl;
        if (!StringUtility.hasText(filePath)) {
            return null;
        }
        boolean bl = isClasspathUrl = filePath.indexOf(58) < 0;
        if (!isClasspathUrl && filePath.startsWith(CLASSPATH_PREFIX)) {
            if (!StringUtility.hasText(filePath = filePath.substring(CLASSPATH_PREFIX.length()))) {
                return null;
            }
            isClasspathUrl = true;
        }
        if (isClasspathUrl) {
            return PropertiesHelper.class.getClassLoader().getResource(filePath);
        }
        return PropertiesHelper.toPropertiesFileUrl(filePath);
    }

    protected static URL toPropertiesFileUrl(String filePath) {
        try {
            return new URL(filePath);
        }
        catch (MalformedURLException e) {
            LOG.debug("Config file path '{}' is no valid URL. Trying to parse as absolute file path.", (Object)filePath, (Object)e);
            try {
                File local = new File(filePath);
                if (local.isFile() && local.isAbsolute()) {
                    return local.toURI().toURL();
                }
                throw new IllegalArgumentException("Invalid config file path: '" + filePath + "'.");
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Unable to load config file with URL '" + filePath + "'.", e2);
            }
        }
    }

    protected void importAll(Set<String> importsToIgnore, Pattern pat) {
        List<String> rawImports = this.getPropertyList(IMPORT_KEY);
        if (rawImports.isEmpty()) {
            return;
        }
        ArrayList<String> imports = new ArrayList<String>(rawImports.size());
        for (String s : rawImports) {
            imports.add(this.resolve(s, pat));
        }
        HashSet<String> ignore = new HashSet<String>(importsToIgnore);
        ignore.addAll(imports);
        for (String importUrl : imports) {
            if (importsToIgnore.contains(importUrl)) {
                LOG.warn("Import of '{}' skipped because already imported: {}.", (Object)importUrl, importsToIgnore);
                continue;
            }
            PropertiesHelper importHelper = new PropertiesHelper(importUrl, ignore);
            if (importHelper.isInitialized()) {
                this.importFrom(importHelper);
                continue;
            }
            throw new IllegalArgumentException("Config import with URL '" + importUrl + "' could not be found.");
        }
    }

    protected void importFrom(PropertiesHelper other) {
        for (Map.Entry<String, String> importEntry : other.getAllEntries().entrySet()) {
            String key = importEntry.getKey();
            String valueFromImport = importEntry.getValue();
            String existing = this.m_configProperties.get(key);
            if (existing != null) {
                this.logDuplicateKey(key, valueFromImport, existing);
                continue;
            }
            this.m_configProperties.put(key, valueFromImport);
        }
    }

    protected void resolveAll(Pattern pat) {
        for (Map.Entry<String, String> entry : this.m_configProperties.entrySet()) {
            entry.setValue(this.resolve(entry.getValue(), pat));
        }
    }

    private void logDuplicateKey(Object key, Object oldValue, Object newValue) {
        LOG.warn("Duplicate config key: '{}'. Old value '{}' replaced with '{}'.", new Object[]{key, oldValue, newValue});
    }

    protected Map<String, String> getConfigPropertyMap() {
        return this.m_configProperties;
    }

    protected void parse(URL propertiesFileUrl) {
        ServiceLoader<IConfigFileLoader> services = ServiceLoader.load(IConfigFileLoader.class);
        IConfigFileLoader loader = null;
        for (IConfigFileLoader service : services) {
            loader = service;
            if (loader != null) break;
        }
        if (loader == null) {
            loader = new DefaultConfigFileLoader();
        }
        Properties props = new Properties(){
            private static final long serialVersionUID = 1L;

            @Override
            public synchronized Object put(Object key, Object value) {
                Object oldValue = super.put(key, value);
                if (oldValue != null) {
                    PropertiesHelper.this.logDuplicateKey(key, oldValue, value);
                }
                return oldValue;
            }
        };
        LOG.info("Reading properties from {} using {}", (Object)propertiesFileUrl, (Object)loader.getClass().getName());
        loader.load(propertiesFileUrl, props);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtility.hasText(key)) continue;
            this.m_configProperties.put(key, value);
        }
    }
}

