/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.config;

import org.eclipse.scout.rt.platform.config.IConfigProperty;

public class ConfigPropertyChangeEvent {
    public static final int TYPE_VALUE_CHANGED = 1;
    public static final int TYPE_INVALIDATE = 2;
    public static final int TYPE_VALUE_INITIALIZED = 3;
    private final IConfigProperty<?> m_configProperty;
    private final String m_namespace;
    private final Object m_oldValue;
    private final Object m_newValue;
    private final int m_type;

    public ConfigPropertyChangeEvent(IConfigProperty<?> configProperty, Object oldValue, Object newValue, String namespace, int type) {
        this.m_configProperty = configProperty;
        this.m_oldValue = oldValue;
        this.m_newValue = newValue;
        this.m_type = type;
        this.m_namespace = namespace;
    }

    public IConfigProperty<?> getConfigProperty() {
        return this.m_configProperty;
    }

    public Object getOldValue() {
        return this.m_oldValue;
    }

    public Object getNewValue() {
        return this.m_newValue;
    }

    public int getType() {
        return this.m_type;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_configProperty == null ? 0 : this.m_configProperty.hashCode());
        result = 31 * result + (this.m_namespace == null ? 0 : this.m_namespace.hashCode());
        result = 31 * result + (this.m_newValue == null ? 0 : this.m_newValue.hashCode());
        result = 31 * result + (this.m_oldValue == null ? 0 : this.m_oldValue.hashCode());
        result = 31 * result + this.m_type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigPropertyChangeEvent other = (ConfigPropertyChangeEvent)obj;
        if (this.m_configProperty == null ? other.m_configProperty != null : !this.m_configProperty.equals(other.m_configProperty)) {
            return false;
        }
        if (this.m_namespace == null ? other.m_namespace != null : !this.m_namespace.equals(other.m_namespace)) {
            return false;
        }
        if (this.m_newValue == null ? other.m_newValue != null : !this.m_newValue.equals(other.m_newValue)) {
            return false;
        }
        if (this.m_oldValue == null ? other.m_oldValue != null : !this.m_oldValue.equals(other.m_oldValue)) {
            return false;
        }
        return this.m_type == other.m_type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConfigPropertyChangeEvent [");
        builder.append("property=").append(this.m_configProperty.getKey()).append(", ");
        if (this.m_namespace != null) {
            builder.append("namespace=").append(this.m_namespace).append(", ");
        }
        if (this.m_oldValue != null) {
            builder.append("oldValue=").append(this.m_oldValue).append(", ");
        }
        if (this.m_newValue != null) {
            builder.append("newValue=").append(this.m_newValue).append(", ");
        }
        builder.append("type=").append(this.m_type).append("]");
        return builder.toString();
    }
}

