/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.eclipse.scout.rt.platform.DefaultPlatform;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.internal.PlatformStarter;

public final class Platform {
    private static volatile IPlatform platform;

    private Platform() {
    }

    public static IPlatform get() {
        IPlatform platformAccessor = platform;
        if (platformAccessor != null) {
            return platformAccessor;
        }
        Platform.initialize();
        return platform;
    }

    public static IPlatform peek() {
        return platform;
    }

    public static void set(IPlatform p) {
        platform = p;
    }

    private static synchronized void initialize() {
        if (platform != null) {
            return;
        }
        IPlatform tmpPlatform = null;
        ServiceLoader<IPlatform> loader = ServiceLoader.load(IPlatform.class);
        Iterator<IPlatform> iterator = loader.iterator();
        if (iterator.hasNext()) {
            IPlatform p;
            tmpPlatform = p = iterator.next();
        }
        if (tmpPlatform == null) {
            tmpPlatform = new DefaultPlatform();
        }
        new PlatformStarter(tmpPlatform).start();
        tmpPlatform.awaitPlatformStarting();
        platform = tmpPlatform;
    }
}

