/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.terminal.swing.GraphicalTerminalImplementation;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;

class TerminalInputMethodRequests
implements InputMethodRequests {
    private Component owner;
    private GraphicalTerminalImplementation terminalImplementation;

    public TerminalInputMethodRequests(Component owner, GraphicalTerminalImplementation terminalImplementation) {
        this.owner = owner;
        this.terminalImplementation = terminalImplementation;
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        Point location = this.owner.getLocationOnScreen();
        TerminalPosition cursorPosition = this.terminalImplementation.getCursorPosition();
        int offsetX = cursorPosition.getColumn() * this.terminalImplementation.getFontWidth();
        int offsetY = cursorPosition.getRow() * this.terminalImplementation.getFontHeight() + this.terminalImplementation.getFontHeight();
        return new Rectangle(location.x + offsetX, location.y + offsetY, 0, 0);
    }

    @Override
    public TextHitInfo getLocationOffset(int x, int y) {
        return null;
    }

    @Override
    public int getInsertPositionOffset() {
        return 0;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public int getCommittedTextLength() {
        return 0;
    }

    @Override
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    @Override
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }
}

