/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.terminal.IOSafeTerminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import com.googlecode.lanterna.terminal.swing.AWTTerminal;
import com.googlecode.lanterna.terminal.swing.AWTTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorAutoCloseTrigger;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorColorConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorDeviceConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class AWTTerminalFrame
extends Frame
implements IOSafeTerminal {
    private final AWTTerminal awtTerminal;
    private final EnumSet<TerminalEmulatorAutoCloseTrigger> autoCloseTriggers;
    private boolean disposed;

    public AWTTerminalFrame(TerminalEmulatorAutoCloseTrigger ... autoCloseTriggers) {
        this("AwtTerminalFrame", autoCloseTriggers);
    }

    public AWTTerminalFrame(String title, TerminalEmulatorAutoCloseTrigger ... autoCloseTriggers) throws HeadlessException {
        this(title, new AWTTerminal(), autoCloseTriggers);
    }

    public AWTTerminalFrame(String title, TerminalEmulatorDeviceConfiguration deviceConfiguration, AWTTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalEmulatorAutoCloseTrigger ... autoCloseTriggers) {
        this(title, null, deviceConfiguration, fontConfiguration, colorConfiguration, autoCloseTriggers);
    }

    public AWTTerminalFrame(String title, TerminalSize terminalSize, TerminalEmulatorDeviceConfiguration deviceConfiguration, AWTTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalEmulatorAutoCloseTrigger ... autoCloseTriggers) {
        this(title, new AWTTerminal(terminalSize, deviceConfiguration, fontConfiguration, colorConfiguration), autoCloseTriggers);
    }

    private AWTTerminalFrame(String title, AWTTerminal awtTerminal, TerminalEmulatorAutoCloseTrigger ... autoCloseTrigger) {
        super(title != null ? title : "AWTTerminalFrame");
        this.awtTerminal = awtTerminal;
        this.autoCloseTriggers = EnumSet.copyOf(Arrays.asList(autoCloseTrigger));
        this.disposed = false;
        this.setLayout(new BorderLayout());
        this.add((Component)awtTerminal, "Center");
        this.setBackground(Color.BLACK);
        this.pack();
        awtTerminal.requestFocusInWindow();
    }

    public AWTTerminalFontConfiguration getFontConfiguration() {
        return this.awtTerminal.getFontConfiguration();
    }

    public TerminalEmulatorColorConfiguration getColorConfiguration() {
        return this.awtTerminal.getColorConfiguration();
    }

    public TerminalEmulatorDeviceConfiguration getDeviceConfiguration() {
        return this.awtTerminal.getDeviceConfiguration();
    }

    public Set<TerminalEmulatorAutoCloseTrigger> getAutoCloseTrigger() {
        return EnumSet.copyOf(this.autoCloseTriggers);
    }

    public void addAutoCloseTrigger(TerminalEmulatorAutoCloseTrigger autoCloseTrigger) {
        this.autoCloseTriggers.add(autoCloseTrigger);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposed = true;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public void addInput(KeyStroke keyStroke) {
        this.awtTerminal.addInput(keyStroke);
    }

    @Override
    public KeyStroke pollInput() {
        if (this.disposed) {
            return new KeyStroke(KeyType.EOF);
        }
        KeyStroke keyStroke = this.awtTerminal.pollInput();
        if (this.autoCloseTriggers.contains((Object)TerminalEmulatorAutoCloseTrigger.CloseOnEscape) && keyStroke != null && keyStroke.getKeyType() == KeyType.Escape) {
            this.dispose();
        }
        return keyStroke;
    }

    @Override
    public KeyStroke readInput() {
        return this.awtTerminal.readInput();
    }

    @Override
    public void enterPrivateMode() {
        this.awtTerminal.enterPrivateMode();
    }

    @Override
    public void exitPrivateMode() {
        this.awtTerminal.exitPrivateMode();
        if (this.autoCloseTriggers.contains((Object)TerminalEmulatorAutoCloseTrigger.CloseOnExitPrivateMode)) {
            this.dispose();
        }
    }

    @Override
    public void clearScreen() {
        this.awtTerminal.clearScreen();
    }

    @Override
    public void setCursorPosition(int x, int y) {
        this.awtTerminal.setCursorPosition(x, y);
    }

    @Override
    public void setCursorPosition(TerminalPosition position) {
        this.awtTerminal.setCursorPosition(position);
    }

    @Override
    public TerminalPosition getCursorPosition() {
        return this.awtTerminal.getCursorPosition();
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.awtTerminal.setCursorVisible(visible);
    }

    @Override
    public void putCharacter(char c) {
        this.awtTerminal.putCharacter(c);
    }

    @Override
    public void putString(String string) {
        this.awtTerminal.putString(string);
    }

    @Override
    public TextGraphics newTextGraphics() {
        return this.awtTerminal.newTextGraphics();
    }

    @Override
    public void enableSGR(SGR sgr) {
        this.awtTerminal.enableSGR(sgr);
    }

    @Override
    public void disableSGR(SGR sgr) {
        this.awtTerminal.disableSGR(sgr);
    }

    @Override
    public void resetColorAndSGR() {
        this.awtTerminal.resetColorAndSGR();
    }

    @Override
    public void setForegroundColor(TextColor color) {
        this.awtTerminal.setForegroundColor(color);
    }

    @Override
    public void setBackgroundColor(TextColor color) {
        this.awtTerminal.setBackgroundColor(color);
    }

    @Override
    public TerminalSize getTerminalSize() {
        return this.awtTerminal.getTerminalSize();
    }

    @Override
    public byte[] enquireTerminal(int timeout, TimeUnit timeoutUnit) {
        return this.awtTerminal.enquireTerminal(timeout, timeoutUnit);
    }

    @Override
    public void bell() {
        this.awtTerminal.bell();
    }

    @Override
    public void flush() {
        this.awtTerminal.flush();
    }

    @Override
    public void addResizeListener(TerminalResizeListener listener) {
        this.awtTerminal.addResizeListener(listener);
    }

    @Override
    public void removeResizeListener(TerminalResizeListener listener) {
        this.awtTerminal.removeResizeListener(listener);
    }
}

