/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.ansi;

import com.googlecode.lanterna.terminal.ansi.TelnetTerminal;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import javax.net.ServerSocketFactory;

public class TelnetTerminalServer {
    private final Charset charset;
    private final ServerSocket serverSocket;

    public TelnetTerminalServer(int port) throws IOException {
        this(ServerSocketFactory.getDefault(), port);
    }

    public TelnetTerminalServer(int port, Charset charset) throws IOException {
        this(ServerSocketFactory.getDefault(), port, charset);
    }

    public TelnetTerminalServer(ServerSocketFactory serverSocketFactory, int port) throws IOException {
        this(serverSocketFactory, port, Charset.defaultCharset());
    }

    public TelnetTerminalServer(ServerSocketFactory serverSocketFactory, int port, Charset charset) throws IOException {
        this.serverSocket = serverSocketFactory.createServerSocket(port);
        this.charset = charset;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public TelnetTerminal acceptConnection() throws IOException {
        Socket clientSocket = this.serverSocket.accept();
        clientSocket.setTcpNoDelay(true);
        return new TelnetTerminal(clientSocket, this.charset);
    }

    public void close() throws IOException {
        this.serverSocket.close();
    }
}

