/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2.table;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.table.Table;
import com.googlecode.lanterna.gui2.table.TableCellRenderer;

public class DefaultTableCellRenderer<V>
implements TableCellRenderer<V> {
    @Override
    public TerminalSize getPreferredSize(Table<V> table, V cell, int columnIndex, int rowIndex) {
        String[] lines = this.getContent(cell);
        int maxWidth = 0;
        for (String line : lines) {
            int length = TerminalTextUtils.getColumnWidth(line);
            if (maxWidth >= length) continue;
            maxWidth = length;
        }
        return new TerminalSize(maxWidth, lines.length);
    }

    @Override
    public void drawCell(Table<V> table, V cell, int columnIndex, int rowIndex, TextGUIGraphics textGUIGraphics) {
        boolean isSelected = table.getSelectedColumn() == columnIndex && table.getSelectedRow() == rowIndex || table.getSelectedRow() == rowIndex && !table.isCellSelection();
        this.applyStyle(table, cell, columnIndex, rowIndex, isSelected, textGUIGraphics);
        this.beforeRender(table, cell, columnIndex, rowIndex, isSelected, textGUIGraphics);
        this.render(table, cell, columnIndex, rowIndex, isSelected, textGUIGraphics);
        this.afterRender(table, cell, columnIndex, rowIndex, isSelected, textGUIGraphics);
    }

    protected void applyStyle(Table<V> table, V cell, int columnIndex, int rowIndex, boolean isSelected, TextGUIGraphics textGUIGraphics) {
        ThemeDefinition themeDefinition = table.getThemeDefinition();
        if (isSelected) {
            if (table.isFocused()) {
                textGUIGraphics.applyThemeStyle(themeDefinition.getActive());
            } else {
                textGUIGraphics.applyThemeStyle(themeDefinition.getSelected());
            }
        } else {
            textGUIGraphics.applyThemeStyle(themeDefinition.getNormal());
        }
    }

    protected void beforeRender(Table<V> table, V cell, int columnIndex, int rowIndex, boolean isSelected, TextGUIGraphics textGUIGraphics) {
        textGUIGraphics.fill(' ');
    }

    protected void render(Table<V> table, V cell, int columnIndex, int rowIndex, boolean isSelected, TextGUIGraphics textGUIGraphics) {
        String[] lines = this.getContent(cell);
        int rowCount = 0;
        for (String line : lines) {
            textGUIGraphics.putString(0, rowCount++, line);
        }
    }

    protected void afterRender(Table<V> table, V cell, int columnIndex, int rowIndex, boolean isSelected, TextGUIGraphics textGUIGraphics) {
    }

    protected String[] getContent(V cell) {
        String[] lines = cell == null ? new String[]{""} : cell.toString().split("\r?\n");
        return lines;
    }
}

