/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.graphics.ThemeStyle;
import com.googlecode.lanterna.gui2.AbstractListBox;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.input.MouseAction;
import com.googlecode.lanterna.input.MouseActionType;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class RadioBoxList<V>
extends AbstractListBox<V, RadioBoxList<V>> {
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private int checkedIndex = -1;

    public RadioBoxList() {
        this(null);
    }

    public RadioBoxList(TerminalSize preferredSize) {
        super(preferredSize);
    }

    @Override
    protected AbstractListBox.ListItemRenderer<V, RadioBoxList<V>> createDefaultListItemRenderer() {
        return new RadioBoxListItemRenderer();
    }

    @Override
    public synchronized Interactable.Result handleKeyStroke(KeyStroke keyStroke) {
        if (this.isKeyboardActivationStroke(keyStroke)) {
            this.setCheckedIndex(this.getSelectedIndex());
        } else if (keyStroke.getKeyType() == KeyType.MouseEvent) {
            int newIndex;
            MouseAction mouseAction = (MouseAction)keyStroke;
            MouseActionType actionType = mouseAction.getActionType();
            if (this.isMouseMove(keyStroke) || actionType == MouseActionType.CLICK_RELEASE || actionType == MouseActionType.SCROLL_UP || actionType == MouseActionType.SCROLL_DOWN) {
                return super.handleKeyStroke(keyStroke);
            }
            int existingIndex = this.getSelectedIndex();
            if (existingIndex != (newIndex = this.getIndexByMouseAction(mouseAction)) || !this.isFocused()) {
                Interactable.Result result = super.handleKeyStroke(keyStroke);
                this.setCheckedIndex(this.getSelectedIndex());
                return result;
            }
            this.setCheckedIndex(this.getSelectedIndex());
            return Interactable.Result.HANDLED;
        }
        return super.handleKeyStroke(keyStroke);
    }

    @Override
    public synchronized V removeItem(int index) {
        Object item = super.removeItem(index);
        if (index < this.checkedIndex) {
            --this.checkedIndex;
        }
        while (this.checkedIndex >= this.getItemCount()) {
            --this.checkedIndex;
        }
        return item;
    }

    @Override
    public synchronized RadioBoxList<V> clearItems() {
        this.setCheckedIndex(-1);
        return (RadioBoxList)super.clearItems();
    }

    public synchronized Boolean isChecked(V object) {
        if (object == null) {
            return null;
        }
        if (this.indexOf(object) == -1) {
            return null;
        }
        return this.checkedIndex == this.indexOf(object);
    }

    public synchronized boolean isChecked(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return false;
        }
        return this.checkedIndex == index;
    }

    public synchronized void setCheckedItem(V item) {
        if (item == null) {
            this.setCheckedIndex(-1);
        } else {
            this.setCheckedItemIndex(this.indexOf(item));
        }
    }

    public synchronized void setCheckedItemIndex(int index) {
        if (index < -1 || index >= this.getItemCount()) {
            return;
        }
        this.setCheckedIndex(index);
    }

    public int getCheckedItemIndex() {
        return this.checkedIndex;
    }

    public synchronized V getCheckedItem() {
        if (this.checkedIndex == -1 || this.checkedIndex >= this.getItemCount()) {
            return null;
        }
        return this.getItemAt(this.checkedIndex);
    }

    public synchronized void clearSelection() {
        this.setCheckedIndex(-1);
    }

    public RadioBoxList<V> addListener(Listener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    public RadioBoxList<V> removeListener(Listener listener) {
        this.listeners.remove(listener);
        return this;
    }

    private void setCheckedIndex(int index) {
        int previouslyChecked = this.checkedIndex;
        this.checkedIndex = index;
        this.invalidate();
        this.runOnGUIThreadIfExistsOtherwiseRunDirect(() -> {
            for (Listener listener : this.listeners) {
                listener.onSelectionChanged(this.checkedIndex, previouslyChecked);
            }
        });
    }

    public static class RadioBoxListItemRenderer<V>
    extends AbstractListBox.ListItemRenderer<V, RadioBoxList<V>> {
        @Override
        public int getHotSpotPositionOnLine(int selectedIndex) {
            return 1;
        }

        @Override
        public String getLabel(RadioBoxList<V> listBox, int index, V item) {
            String check = " ";
            if (((RadioBoxList)listBox).checkedIndex == index) {
                check = "o";
            }
            String text = (item != null ? item : "<null>").toString();
            return "<" + check + "> " + text;
        }

        @Override
        public void drawItem(TextGUIGraphics graphics, RadioBoxList<V> listBox, int index, V item, boolean selected, boolean focused) {
            ThemeDefinition themeDefinition = listBox.getTheme().getDefinition(RadioBoxList.class);
            ThemeStyle itemStyle = selected && !focused ? themeDefinition.getSelected() : (selected ? themeDefinition.getActive() : (focused ? themeDefinition.getInsensitive() : themeDefinition.getNormal()));
            if (themeDefinition.getBooleanProperty("CLEAR_WITH_NORMAL", false)) {
                graphics.applyThemeStyle(themeDefinition.getNormal());
                graphics.fill(' ');
                graphics.applyThemeStyle(itemStyle);
            } else {
                graphics.applyThemeStyle(itemStyle);
                graphics.fill(' ');
            }
            String brackets = themeDefinition.getCharacter("LEFT_BRACKET", '<') + " " + themeDefinition.getCharacter("RIGHT_BRACKET", '>');
            if (themeDefinition.getBooleanProperty("FIXED_BRACKET_COLOR", false)) {
                graphics.applyThemeStyle(themeDefinition.getPreLight());
                graphics.putString(0, 0, brackets);
                graphics.applyThemeStyle(itemStyle);
            } else {
                graphics.putString(0, 0, brackets);
            }
            String text = (item != null ? item : "<null>").toString();
            graphics.putString(4, 0, text);
            boolean itemChecked = ((RadioBoxList)listBox).checkedIndex == index;
            char marker = themeDefinition.getCharacter("MARKER", 'o');
            if (themeDefinition.getBooleanProperty("MARKER_WITH_NORMAL", false)) {
                graphics.applyThemeStyle(themeDefinition.getNormal());
            }
            if (selected && focused && themeDefinition.getBooleanProperty("HOTSPOT_PRELIGHT", false)) {
                graphics.applyThemeStyle(themeDefinition.getPreLight());
            }
            graphics.setCharacter(1, 0, itemChecked ? marker : (char)' ');
        }
    }

    public static interface Listener {
        public void onSelectionChanged(int var1, int var2);
    }
}

