/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.gui2.AbsoluteLayout;
import com.googlecode.lanterna.gui2.AbstractComponent;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.ComponentRenderer;
import com.googlecode.lanterna.gui2.Container;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.InteractableLookupMap;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LinearLayout;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Panel
extends AbstractComponent<Panel>
implements Container {
    private final List<Component> components;
    private LayoutManager layoutManager;
    private TerminalSize cachedPreferredSize;
    private TextColor fillColorOverride;

    public Panel() {
        this(new LinearLayout());
    }

    public Panel(LayoutManager layoutManager) {
        if (layoutManager == null) {
            layoutManager = new AbsoluteLayout();
        }
        this.components = new ArrayList<Component>();
        this.layoutManager = layoutManager;
        this.cachedPreferredSize = null;
    }

    public Panel addComponent(Component component) {
        return this.addComponent(Integer.MAX_VALUE, component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Panel addComponent(int index, Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Cannot add null component");
        }
        List<Component> list = this.components;
        synchronized (list) {
            if (this.components.contains(component)) {
                return this;
            }
            if (component.getParent() != null) {
                component.getParent().removeComponent(component);
            }
            if (index > this.components.size()) {
                index = this.components.size();
            } else if (index < 0) {
                index = 0;
            }
            this.components.add(index, component);
        }
        component.onAdded(this);
        this.invalidate();
        return this;
    }

    public Panel addComponent(Component component, LayoutData layoutData) {
        if (component != null) {
            component.setLayoutData(layoutData);
            this.addComponent(component);
        }
        return this;
    }

    @Override
    public boolean containsComponent(Component component) {
        return component != null && component.hasParent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeComponent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("Cannot remove null component");
        }
        List<Component> list = this.components;
        synchronized (list) {
            int index = this.components.indexOf(component);
            if (index == -1) {
                return false;
            }
            if (this.getBasePane() != null && this.getBasePane().getFocusedInteractable() == component) {
                this.getBasePane().setFocusedInteractable(null);
            }
            this.components.remove(index);
        }
        component.onRemoved(this);
        this.invalidate();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Panel removeAllComponents() {
        List<Component> list = this.components;
        synchronized (list) {
            for (Component component : new ArrayList<Component>(this.components)) {
                this.removeComponent(component);
            }
        }
        return this;
    }

    public synchronized Panel setLayoutManager(LayoutManager layoutManager) {
        if (layoutManager == null) {
            layoutManager = new AbsoluteLayout();
        }
        this.layoutManager = layoutManager;
        this.invalidate();
        return this;
    }

    public TextColor getFillColorOverride() {
        return this.fillColorOverride;
    }

    public void setFillColorOverride(TextColor fillColor) {
        this.fillColorOverride = fillColor;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildCount() {
        List<Component> list = this.components;
        synchronized (list) {
            return this.components.size();
        }
    }

    @Override
    public Collection<Component> getChildren() {
        return this.getChildrenList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Component> getChildrenList() {
        List<Component> list = this.components;
        synchronized (list) {
            return new ArrayList<Component>(this.components);
        }
    }

    @Override
    protected ComponentRenderer<Panel> createDefaultRenderer() {
        return new DefaultPanelRenderer();
    }

    @Override
    public TerminalSize calculatePreferredSize() {
        if (this.cachedPreferredSize != null && !this.isInvalid()) {
            return this.cachedPreferredSize;
        }
        return super.calculatePreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInvalid() {
        List<Component> list = this.components;
        synchronized (list) {
            for (Component component : this.components) {
                if (!component.isInvalid()) continue;
                return true;
            }
        }
        return super.isInvalid() || this.layoutManager.hasChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactable nextFocus(Interactable fromThis) {
        boolean chooseNextAvailable = fromThis == null;
        List<Component> list = this.components;
        synchronized (list) {
            for (Component component : this.components) {
                Container container;
                if (!component.isVisible()) continue;
                if (chooseNextAvailable) {
                    Interactable firstInteractable;
                    if (component instanceof Interactable && ((Interactable)component).isEnabled() && ((Interactable)component).isFocusable()) {
                        return (Interactable)component;
                    }
                    if (!(component instanceof Container) || (firstInteractable = ((Container)component).nextFocus(null)) == null) continue;
                    return firstInteractable;
                }
                if (component == fromThis) {
                    chooseNextAvailable = true;
                    continue;
                }
                if (!(component instanceof Container) || !fromThis.isInside(container = (Container)component)) continue;
                Interactable next = container.nextFocus(fromThis);
                if (next == null) {
                    chooseNextAvailable = true;
                    continue;
                }
                return next;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactable previousFocus(Interactable fromThis) {
        ArrayList<Component> reversedComponentList;
        boolean chooseNextAvailable = fromThis == null;
        List<Component> list = this.components;
        synchronized (list) {
            reversedComponentList = new ArrayList<Component>(this.components);
        }
        Collections.reverse(reversedComponentList);
        for (Component component : reversedComponentList) {
            Container container;
            if (!component.isVisible()) continue;
            if (chooseNextAvailable) {
                Interactable lastInteractable;
                if (component instanceof Interactable && ((Interactable)component).isEnabled() && ((Interactable)component).isFocusable()) {
                    return (Interactable)component;
                }
                if (!(component instanceof Container) || (lastInteractable = ((Container)component).previousFocus(null)) == null) continue;
                return lastInteractable;
            }
            if (component == fromThis) {
                chooseNextAvailable = true;
                continue;
            }
            if (!(component instanceof Container) || !fromThis.isInside(container = (Container)component)) continue;
            Interactable next = container.previousFocus(fromThis);
            if (next == null) {
                chooseNextAvailable = true;
                continue;
            }
            return next;
        }
        return null;
    }

    @Override
    public boolean handleInput(KeyStroke key) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLookupMap(InteractableLookupMap interactableLookupMap) {
        List<Component> list = this.components;
        synchronized (list) {
            for (Component component : this.components) {
                if (!component.isVisible()) continue;
                if (component instanceof Container) {
                    ((Container)component).updateLookupMap(interactableLookupMap);
                    continue;
                }
                if (!(component instanceof Interactable) || !((Interactable)component).isEnabled() || !((Interactable)component).isFocusable()) continue;
                interactableLookupMap.add((Interactable)component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        super.invalidate();
        List<Component> list = this.components;
        synchronized (list) {
            for (Component component : this.components) {
                component.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layout(TerminalSize size) {
        List<Component> list = this.components;
        synchronized (list) {
            this.layoutManager.doLayout(size, this.components);
        }
    }

    public class DefaultPanelRenderer
    implements ComponentRenderer<Panel> {
        private boolean fillAreaBeforeDrawingComponents = true;

        public void setFillAreaBeforeDrawingComponents(boolean fillAreaBeforeDrawingComponents) {
            this.fillAreaBeforeDrawingComponents = fillAreaBeforeDrawingComponents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TerminalSize getPreferredSize(Panel component) {
            List list = Panel.this.components;
            synchronized (list) {
                Panel.this.cachedPreferredSize = Panel.this.layoutManager.getPreferredSize(Panel.this.components);
            }
            return Panel.this.cachedPreferredSize;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drawComponent(TextGUIGraphics graphics, Panel panel) {
            if (Panel.this.isInvalid()) {
                Panel.this.layout(graphics.getSize());
            }
            if (this.fillAreaBeforeDrawingComponents) {
                graphics.applyThemeStyle(Panel.this.getThemeDefinition().getNormal());
                if (Panel.this.fillColorOverride != null) {
                    graphics.setBackgroundColor(Panel.this.fillColorOverride);
                }
                graphics.fill(' ');
            }
            List list = Panel.this.components;
            synchronized (list) {
                for (Component child : Panel.this.components) {
                    if (!child.isVisible()) continue;
                    TextGUIGraphics componentGraphics = graphics.newTextGraphics(child.getPosition(), child.getSize());
                    child.draw(componentGraphics);
                }
            }
        }
    }
}

