/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.graphics.ThemeDefinition;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.WindowDecorationRenderer;

public class FatWindowDecorationRenderer
implements WindowDecorationRenderer {
    private static final TerminalPosition OFFSET_WITH_TITLE = new TerminalPosition(1, 3);
    private static final TerminalPosition OFFSET_WITHOUT_TITLE = new TerminalPosition(1, 1);

    @Override
    public TextGUIGraphics draw(WindowBasedTextGUI textGUI, TextGUIGraphics graphics, Window window) {
        boolean hasTitle;
        String title = window.getTitle();
        if (title == null) {
            title = "";
        }
        boolean bl = hasTitle = !title.trim().isEmpty();
        if (hasTitle) {
            title = " " + title.trim() + " ";
        }
        ThemeDefinition themeDefinition = window.getTheme().getDefinition(FatWindowDecorationRenderer.class);
        char horizontalLine = themeDefinition.getCharacter("HORIZONTAL_LINE", '\u2500');
        char verticalLine = themeDefinition.getCharacter("VERTICAL_LINE", '\u2502');
        char bottomLeftCorner = themeDefinition.getCharacter("BOTTOM_LEFT_CORNER", '\u2514');
        char topLeftCorner = themeDefinition.getCharacter("TOP_LEFT_CORNER", '\u250c');
        char bottomRightCorner = themeDefinition.getCharacter("BOTTOM_RIGHT_CORNER", '\u2518');
        char topRightCorner = themeDefinition.getCharacter("TOP_RIGHT_CORNER", '\u2510');
        char leftJunction = themeDefinition.getCharacter("LEFT_JUNCTION", '\u251c');
        char rightJunction = themeDefinition.getCharacter("RIGHT_JUNCTION", '\u2524');
        TerminalSize drawableArea = graphics.getSize();
        if (hasTitle) {
            graphics.applyThemeStyle(themeDefinition.getPreLight());
            graphics.drawLine(0, drawableArea.getRows() - 2, 0, 1, verticalLine);
            graphics.drawLine(1, 0, drawableArea.getColumns() - 2, 0, horizontalLine);
            graphics.drawLine(1, 2, drawableArea.getColumns() - 2, 2, horizontalLine);
            graphics.setCharacter(0, 0, topLeftCorner);
            graphics.setCharacter(0, 2, leftJunction);
            graphics.setCharacter(0, drawableArea.getRows() - 1, bottomLeftCorner);
            graphics.applyThemeStyle(themeDefinition.getNormal());
            graphics.drawLine(drawableArea.getColumns() - 1, 1, drawableArea.getColumns() - 1, drawableArea.getRows() - 2, verticalLine);
            graphics.drawLine(1, drawableArea.getRows() - 1, drawableArea.getColumns() - 2, drawableArea.getRows() - 1, horizontalLine);
            graphics.setCharacter(drawableArea.getColumns() - 1, 0, topRightCorner);
            graphics.setCharacter(drawableArea.getColumns() - 1, 2, rightJunction);
            graphics.setCharacter(drawableArea.getColumns() - 1, drawableArea.getRows() - 1, bottomRightCorner);
            graphics.applyThemeStyle(themeDefinition.getActive());
            graphics.drawLine(1, 1, drawableArea.getColumns() - 2, 1, ' ');
            graphics.putString(1, 1, TerminalTextUtils.fitString(title, drawableArea.getColumns() - 3));
            return graphics.newTextGraphics(OFFSET_WITH_TITLE, graphics.getSize().withRelativeColumns(-2).withRelativeRows(-4));
        }
        graphics.applyThemeStyle(themeDefinition.getPreLight());
        graphics.drawLine(0, drawableArea.getRows() - 2, 0, 1, verticalLine);
        graphics.drawLine(1, 0, drawableArea.getColumns() - 2, 0, horizontalLine);
        graphics.setCharacter(0, 0, topLeftCorner);
        graphics.setCharacter(0, drawableArea.getRows() - 1, bottomLeftCorner);
        graphics.applyThemeStyle(themeDefinition.getNormal());
        graphics.drawLine(drawableArea.getColumns() - 1, 1, drawableArea.getColumns() - 1, drawableArea.getRows() - 2, verticalLine);
        graphics.drawLine(1, drawableArea.getRows() - 1, drawableArea.getColumns() - 2, drawableArea.getRows() - 1, horizontalLine);
        graphics.setCharacter(drawableArea.getColumns() - 1, 0, topRightCorner);
        graphics.setCharacter(drawableArea.getColumns() - 1, drawableArea.getRows() - 1, bottomRightCorner);
        return graphics.newTextGraphics(OFFSET_WITHOUT_TITLE, graphics.getSize().withRelativeColumns(-2).withRelativeRows(-2));
    }

    @Override
    public TerminalSize getDecoratedSize(Window window, TerminalSize contentAreaSize) {
        if (this.hasTitle(window)) {
            return contentAreaSize.withRelativeColumns(2).withRelativeRows(4).max(new TerminalSize(TerminalTextUtils.getColumnWidth(window.getTitle()) + 4, 1));
        }
        return contentAreaSize.withRelativeColumns(2).withRelativeRows(2).max(new TerminalSize(3, 1));
    }

    @Override
    public TerminalPosition getOffset(Window window) {
        if (this.hasTitle(window)) {
            return OFFSET_WITH_TITLE;
        }
        return OFFSET_WITHOUT_TITLE;
    }

    private boolean hasTitle(Window window) {
        return window.getTitle() != null && !window.getTitle().trim().isEmpty();
    }
}

