/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalTextUtils;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.StyleSet;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.screen.TabBehaviour;
import com.googlecode.lanterna.screen.WrapBehaviour;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public class TextGraphicsWriter
implements StyleSet<TextGraphicsWriter> {
    private final TextGraphics backend;
    private TerminalPosition cursorPosition;
    private TextColor foregroundColor;
    private TextColor backgroundColor;
    private final EnumSet<SGR> style = EnumSet.noneOf(SGR.class);
    private WrapBehaviour wrapBehaviour = WrapBehaviour.WORD;
    private boolean styleable = true;
    private final List<WordPart> chunk_queue = new ArrayList<WordPart>();

    public TextGraphicsWriter(TextGraphics backend) {
        this.backend = backend;
        this.setStyleFrom((StyleSet)backend);
        this.cursorPosition = new TerminalPosition(0, 0);
    }

    public TextGraphicsWriter putString(String string) {
        StringBuilder wordpart = new StringBuilder();
        StyleSet.Set originalStyle = new StyleSet.Set(this.backend);
        this.backend.setStyleFrom(this);
        int wordlen = 0;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\n': {
                    this.flush(wordpart, wordlen);
                    wordlen = 0;
                    this.linefeed(-1);
                    break;
                }
                case '\t': {
                    this.flush(wordpart, wordlen);
                    wordlen = 0;
                    if (this.backend.getTabBehaviour() != TabBehaviour.IGNORE) {
                        String repl = this.backend.getTabBehaviour().getTabReplacement(this.cursorPosition.getColumn());
                        for (int j = 0; j < repl.length(); ++j) {
                            this.backend.setCharacter(this.cursorPosition.withRelativeColumn(j), repl.charAt(j));
                        }
                        this.cursorPosition = this.cursorPosition.withRelativeColumn(repl.length());
                        break;
                    }
                    this.linefeed(2);
                    this.putControlChar(ch);
                    break;
                }
                case '\u001b': {
                    if (this.isStyleable()) {
                        this.stash(wordpart, wordlen);
                        String seq = TerminalTextUtils.getANSIControlSequenceAt(string, i);
                        TerminalTextUtils.updateModifiersFromCSICode(seq, this, originalStyle);
                        this.backend.setStyleFrom(this);
                        i += seq.length() - 1;
                        break;
                    }
                    this.flush(wordpart, wordlen);
                    wordlen = 0;
                    this.linefeed(2);
                    this.putControlChar(ch);
                    break;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        this.flush(wordpart, wordlen);
                        wordlen = 0;
                        this.linefeed(1);
                        this.putControlChar(ch);
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        this.flush(wordpart, wordlen);
                        wordlen = 0;
                        this.backend.setCharacter(this.cursorPosition, ch);
                        this.cursorPosition = this.cursorPosition.withRelativeColumn(1);
                        break;
                    }
                    if (TerminalTextUtils.isCharCJK(ch)) {
                        this.flush(wordpart, wordlen);
                        wordlen = 0;
                        this.linefeed(2);
                        this.backend.setCharacter(this.cursorPosition, ch);
                        this.cursorPosition = this.cursorPosition.withRelativeColumn(2);
                        break;
                    }
                    if (this.wrapBehaviour.keepWords()) {
                        wordpart.append(ch);
                        ++wordlen;
                        break;
                    }
                    this.linefeed(1);
                    this.backend.setCharacter(this.cursorPosition, ch);
                    this.cursorPosition = this.cursorPosition.withRelativeColumn(1);
                }
            }
            this.linefeed(wordlen);
        }
        this.flush(wordpart, wordlen);
        this.backend.setStyleFrom(originalStyle);
        return this;
    }

    private void linefeed(int lenToFit) {
        int curCol = this.cursorPosition.getColumn();
        int spaceLeft = this.backend.getSize().getColumns() - curCol;
        if (this.wrapBehaviour.allowLineFeed()) {
            boolean wantWrap;
            boolean bl = wantWrap = curCol > 0 && lenToFit > spaceLeft;
            if (lenToFit < 0 || wantWrap && this.wrapBehaviour.autoWrap()) {
                this.cursorPosition = this.cursorPosition.withColumn(0).withRelativeRow(1);
            }
        } else if (lenToFit < 0) {
            this.putControlChar('\n');
        }
    }

    public void putControlChar(char ch) {
        char subst;
        switch (ch) {
            case '\u001b': {
                subst = '[';
                break;
            }
            case '\u001c': {
                subst = '\\';
                break;
            }
            case '\u001d': {
                subst = ']';
                break;
            }
            case '\u001e': {
                subst = '^';
                break;
            }
            case '\u001f': {
                subst = '_';
                break;
            }
            case '\u007f': {
                subst = '?';
                break;
            }
            default: {
                if (ch <= '\u001a') {
                    subst = (char)(ch + 64);
                    break;
                }
                this.backend.setCharacter(this.cursorPosition, ch);
                this.cursorPosition = this.cursorPosition.withRelativeColumn(1);
                return;
            }
        }
        EnumSet<SGR> style = this.getActiveModifiers();
        if (style.contains((Object)SGR.REVERSE)) {
            style.remove((Object)SGR.REVERSE);
        } else {
            style.add(SGR.REVERSE);
        }
        TextCharacter tc = new TextCharacter('^', this.getForegroundColor(), this.getBackgroundColor(), style);
        this.backend.setCharacter(this.cursorPosition, tc);
        this.cursorPosition = this.cursorPosition.withRelativeColumn(1);
        tc = tc.withCharacter(subst);
        this.backend.setCharacter(this.cursorPosition, tc);
        this.cursorPosition = this.cursorPosition.withRelativeColumn(1);
    }

    private void stash(StringBuilder word, int wordlen) {
        if (word.length() > 0) {
            WordPart chunk = new WordPart(word.toString(), wordlen, this);
            this.chunk_queue.add(chunk);
            word.setLength(0);
        }
    }

    private void flush(StringBuilder word, int wordlen) {
        this.stash(word, wordlen);
        if (this.chunk_queue.isEmpty()) {
            return;
        }
        int row = this.cursorPosition.getRow();
        int col = this.cursorPosition.getColumn();
        int offset = 0;
        for (WordPart chunk : this.chunk_queue) {
            this.backend.setStyleFrom(chunk);
            this.backend.putString(col + offset, row, chunk.word);
            offset = chunk.wordlen;
        }
        this.chunk_queue.clear();
        this.cursorPosition = this.cursorPosition.withColumn(col + offset);
        this.backend.setStyleFrom(this);
    }

    public TerminalPosition getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(TerminalPosition cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    @Override
    public TextColor getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public TextGraphicsWriter setForegroundColor(TextColor foreground) {
        this.foregroundColor = foreground;
        return this;
    }

    @Override
    public TextColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public TextGraphicsWriter setBackgroundColor(TextColor background) {
        this.backgroundColor = background;
        return this;
    }

    @Override
    public TextGraphicsWriter enableModifiers(SGR ... modifiers) {
        this.style.addAll(Arrays.asList(modifiers));
        return this;
    }

    @Override
    public TextGraphicsWriter disableModifiers(SGR ... modifiers) {
        this.style.removeAll(Arrays.asList(modifiers));
        return this;
    }

    @Override
    public TextGraphicsWriter setModifiers(EnumSet<SGR> modifiers) {
        this.style.clear();
        this.style.addAll(modifiers);
        return this;
    }

    @Override
    public TextGraphicsWriter clearModifiers() {
        this.style.clear();
        return this;
    }

    @Override
    public EnumSet<SGR> getActiveModifiers() {
        return EnumSet.copyOf(this.style);
    }

    @Override
    public TextGraphicsWriter setStyleFrom(StyleSet<?> source) {
        this.setBackgroundColor(source.getBackgroundColor());
        this.setForegroundColor(source.getForegroundColor());
        this.setModifiers((EnumSet)source.getActiveModifiers());
        return this;
    }

    public WrapBehaviour getWrapBehaviour() {
        return this.wrapBehaviour;
    }

    public void setWrapBehaviour(WrapBehaviour wrapBehaviour) {
        this.wrapBehaviour = wrapBehaviour;
    }

    public boolean isStyleable() {
        return this.styleable;
    }

    public void setStyleable(boolean styleable) {
        this.styleable = styleable;
    }

    private static class WordPart
    extends StyleSet.Set {
        private final String word;
        private final int wordlen;

        WordPart(String word, int wordlen, StyleSet<?> style) {
            this.word = word;
            this.wordlen = wordlen;
            this.setStyleFrom((StyleSet)style);
        }
    }
}

