/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna;

public class TerminalPosition
implements Comparable<TerminalPosition> {
    public static final TerminalPosition TOP_LEFT_CORNER = new TerminalPosition(0, 0);
    public static final TerminalPosition OFFSET_1x1 = new TerminalPosition(1, 1);
    private final int row;
    private final int column;

    public TerminalPosition(int column, int row) {
        this.row = row;
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public TerminalPosition withRow(int row) {
        if (row == 0 && this.column == 0) {
            return TOP_LEFT_CORNER;
        }
        return new TerminalPosition(this.column, row);
    }

    public TerminalPosition withColumn(int column) {
        if (column == 0 && this.row == 0) {
            return TOP_LEFT_CORNER;
        }
        return new TerminalPosition(column, this.row);
    }

    public TerminalPosition withRelativeColumn(int delta) {
        if (delta == 0) {
            return this;
        }
        return this.withColumn(this.column + delta);
    }

    public TerminalPosition withRelativeRow(int delta) {
        if (delta == 0) {
            return this;
        }
        return this.withRow(this.row + delta);
    }

    public TerminalPosition withRelative(TerminalPosition translate) {
        return this.withRelative(translate.getColumn(), translate.getRow());
    }

    public TerminalPosition withRelative(int deltaColumn, int deltaRow) {
        return this.withRelativeRow(deltaRow).withRelativeColumn(deltaColumn);
    }

    public TerminalPosition with(TerminalPosition position) {
        if (this.equals(position)) {
            return this;
        }
        return position;
    }

    public TerminalPosition plus(TerminalPosition position) {
        return this.withRelative(position);
    }

    public TerminalPosition minus(TerminalPosition position) {
        return this.withRelative(-position.getColumn(), -position.getRow());
    }

    public TerminalPosition multiply(TerminalPosition position) {
        return new TerminalPosition(this.column * position.column, this.row * position.row);
    }

    public TerminalPosition divide(TerminalPosition denominator) {
        return new TerminalPosition(this.column / denominator.column, this.row / denominator.row);
    }

    public TerminalPosition abs() {
        int x = Math.abs(this.column);
        int y = Math.abs(this.row);
        return new TerminalPosition(x, y);
    }

    public TerminalPosition min(TerminalPosition position) {
        int x = Math.min(this.column, position.column);
        int y = Math.min(this.row, position.row);
        return new TerminalPosition(x, y);
    }

    public TerminalPosition max(TerminalPosition position) {
        int x = Math.max(this.column, position.column);
        int y = Math.max(this.row, position.row);
        return new TerminalPosition(x, y);
    }

    @Override
    public int compareTo(TerminalPosition o) {
        if (this.row < o.row) {
            return -1;
        }
        if (this.row == o.row) {
            if (this.column < o.column) {
                return -1;
            }
            if (this.column == o.column) {
                return 0;
            }
        }
        return 1;
    }

    public String toString() {
        return "[" + this.column + ":" + this.row + "]";
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + this.row;
        hash = 23 * hash + this.column;
        return hash;
    }

    public boolean equals(int columnIndex, int rowIndex) {
        return this.column == columnIndex && this.row == rowIndex;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerminalPosition other = (TerminalPosition)obj;
        return this.row == other.row && this.column == other.column;
    }
}

