/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.scout.rt.platform.events.IListenerListWithManagement;
import org.eclipse.scout.rt.platform.events.ISnapshotCollector;
import org.eclipse.scout.rt.platform.events.ListenerListRegistry;
import org.eclipse.scout.rt.platform.util.event.UnsafeFastListenerList;

public abstract class AbstractGroupedListenerList<LISTENER, EVENT, EVENT_TYPE>
implements IListenerListWithManagement {
    private final Map<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> m_listenerMap = new HashMap<EVENT_TYPE, UnsafeFastListenerList<LISTENER>>();
    private final Map<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> m_lastListenerMap = new HashMap<EVENT_TYPE, UnsafeFastListenerList<LISTENER>>();

    public AbstractGroupedListenerList() {
        ListenerListRegistry.globalInstance().registerAsWeakReference(this);
    }

    protected Object lockObject() {
        return this.m_listenerMap;
    }

    protected abstract Set<EVENT_TYPE> knownEventTypes();

    protected abstract EVENT_TYPE otherEventsType();

    protected abstract EVENT_TYPE eventType(EVENT var1);

    protected abstract void handleEvent(LISTENER var1, EVENT var2);

    Map<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> internalListenerMap(boolean lastCalled) {
        return lastCalled ? this.m_lastListenerMap : this.m_listenerMap;
    }

    public void fireEvents(List<EVENT> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        for (EVENT e : events) {
            this.fireEvent(e);
        }
    }

    public void fireEvent(EVENT event) {
        List<LISTENER> listeners = this.list(this.eventType(event));
        if (!listeners.isEmpty()) {
            for (LISTENER listener : listeners) {
                this.handleEvent(listener, event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LISTENER> list(EVENT_TYPE eventType) {
        Object object = this.lockObject();
        synchronized (object) {
            return this.collectListenersInsideLock(eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<EVENT_TYPE, List<LISTENER>> listAll() {
        Object object = this.lockObject();
        synchronized (object) {
            HashSet<EVENT_TYPE> types = new HashSet<EVENT_TYPE>();
            types.addAll(this.m_listenerMap.keySet());
            types.addAll(this.m_lastListenerMap.keySet());
            HashMap map = new HashMap();
            for (Object type : types) {
                map.put(type, this.collectListenersInsideLock(type));
            }
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LISTENER listener, boolean weak, EVENT_TYPE ... eventTypes) {
        if (listener == null) {
            return;
        }
        Object object = this.lockObject();
        synchronized (object) {
            if (eventTypes == null || eventTypes.length == 0) {
                for (EVENT_TYPE eventType : this.knownEventTypes()) {
                    this.addInsideLock(this.m_listenerMap, listener, weak, eventType);
                }
                this.addInsideLock(this.m_listenerMap, listener, weak, this.otherEventsType());
            } else {
                EVENT_TYPE[] EVENT_TYPEArray = eventTypes;
                int n = eventTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    EVENT_TYPE eventType = EVENT_TYPEArray[n2];
                    this.addInsideLock(this.m_listenerMap, listener, weak, eventType);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLastCalled(LISTENER listener, boolean weak, EVENT_TYPE ... eventTypes) {
        if (listener == null) {
            return;
        }
        Object object = this.lockObject();
        synchronized (object) {
            if (eventTypes == null || eventTypes.length == 0) {
                for (EVENT_TYPE eventType : this.knownEventTypes()) {
                    this.addInsideLock(this.m_lastListenerMap, listener, weak, eventType);
                }
                this.addInsideLock(this.m_lastListenerMap, listener, weak, this.otherEventsType());
            } else {
                EVENT_TYPE[] EVENT_TYPEArray = eventTypes;
                int n = eventTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    EVENT_TYPE eventType = EVENT_TYPEArray[n2];
                    this.addInsideLock(this.m_lastListenerMap, listener, weak, eventType);
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends AbstractGroupedListenerList<LISTENER, EVENT, EVENT_TYPE>> void addAll(T other) {
        Object object = this.lockObject();
        synchronized (object) {
            Object object2 = other.lockObject();
            synchronized (object2) {
                this.addAllInsideLock(other.internalListenerMap(false), this.internalListenerMap(false));
                this.addAllInsideLock(other.internalListenerMap(true), this.internalListenerMap(true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(LISTENER listener, EVENT_TYPE ... eventTypes) {
        if (listener == null) {
            return;
        }
        Object object = this.lockObject();
        synchronized (object) {
            if (eventTypes == null || eventTypes.length == 0) {
                this.removeInsideLock(this.m_listenerMap, listener, null);
                this.removeInsideLock(this.m_lastListenerMap, listener, null);
            } else {
                EVENT_TYPE[] EVENT_TYPEArray = eventTypes;
                int n = eventTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    EVENT_TYPE eventType = EVENT_TYPEArray[n2];
                    this.removeInsideLock(this.m_listenerMap, listener, eventType);
                    this.removeInsideLock(this.m_lastListenerMap, listener, eventType);
                    ++n2;
                }
            }
        }
    }

    private void addAllInsideLock(Map<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> srcMap, Map<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> dstMap) {
        srcMap.forEach((eventType, srcList) -> dstMap.computeIfAbsent(eventType, eventType2 -> new UnsafeFastListenerList()).addAll(srcList));
    }

    private void addInsideLock(Map<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> listenerMap, LISTENER listener, boolean weak, EVENT_TYPE eventType) {
        if (listener == null) {
            return;
        }
        UnsafeFastListenerList<LISTENER> listeners = listenerMap.get(eventType);
        if (listeners == null) {
            listeners = new UnsafeFastListenerList();
            listenerMap.put(eventType, listeners);
        }
        listeners.add(listener, weak);
    }

    private void removeInsideLock(Map<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> listenerMap, LISTENER listener, EVENT_TYPE queryType) {
        if (listener == null) {
            return;
        }
        Iterator<Map.Entry<EVENT_TYPE, UnsafeFastListenerList<LISTENER>>> it = listenerMap.entrySet().iterator();
        while (it.hasNext()) {
            UnsafeFastListenerList<LISTENER> listeners;
            Map.Entry<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> e = it.next();
            EVENT_TYPE eventType = e.getKey();
            if (queryType != null && !Objects.equals(queryType, eventType) || (listeners = e.getValue()) == null) continue;
            listeners.remove(listener);
            if (!listeners.isEmpty()) continue;
            it.remove();
        }
    }

    private List<LISTENER> collectListenersInsideLock(EVENT_TYPE eventType) {
        ArrayList result = new ArrayList();
        boolean knownEventType = this.knownEventTypes().contains(eventType);
        this.collectListenersInsideLock(this.m_listenerMap, eventType, result);
        if (!knownEventType) {
            this.collectListenersInsideLock(this.m_listenerMap, this.otherEventsType(), result);
        }
        this.collectListenersInsideLock(this.m_lastListenerMap, eventType, result);
        if (!knownEventType) {
            this.collectListenersInsideLock(this.m_lastListenerMap, this.otherEventsType(), result);
        }
        return result;
    }

    private void collectListenersInsideLock(Map<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> listenerMap, EVENT_TYPE eventType, ArrayList<LISTENER> result) {
        UnsafeFastListenerList<LISTENER> listeners = listenerMap.get(eventType);
        if (listeners == null) {
            return;
        }
        if (listeners.isEmpty()) {
            listenerMap.remove(eventType);
            return;
        }
        result.addAll(listeners.list());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSnapshot(ISnapshotCollector snapshot) {
        Object object = this.lockObject();
        synchronized (object) {
            String context;
            UnsafeFastListenerList<LISTENER> listeners;
            EVENT_TYPE eventType;
            for (Map.Entry<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> e : this.m_listenerMap.entrySet()) {
                eventType = e.getKey();
                listeners = e.getValue();
                context = "eventType: " + (eventType == this.otherEventsType() ? "unknown/other" : eventType);
                for (LISTENER listener : listeners.list()) {
                    snapshot.add(context, listener);
                }
            }
            for (Map.Entry<EVENT_TYPE, UnsafeFastListenerList<LISTENER>> e : this.m_lastListenerMap.entrySet()) {
                eventType = e.getKey();
                listeners = e.getValue();
                context = "lastListeners of eventType: " + (eventType == this.otherEventsType() ? "unknown/other" : eventType);
                for (LISTENER listener : listeners.list()) {
                    snapshot.add(context, listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        LinkedHashSet<String> namesInReverseOrder = new LinkedHashSet<String>();
        Object object = this.lockObject();
        synchronized (object) {
            for (UnsafeFastListenerList<LISTENER> listeners : this.m_lastListenerMap.values()) {
                for (LISTENER listener : listeners.list()) {
                    namesInReverseOrder.add(listener.toString());
                }
            }
            for (UnsafeFastListenerList<LISTENER> listeners : this.m_listenerMap.values()) {
                for (LISTENER listener : listeners.list()) {
                    namesInReverseOrder.add(listener.toString());
                }
            }
        }
        String[] rev = namesInReverseOrder.toArray(new String[0]);
        StringBuilder sb = new StringBuilder("listeners[" + rev.length + "]");
        if (rev.length > 0) {
            sb.append(": ");
            int i = rev.length - 1;
            while (i >= 0) {
                sb.append(rev[i]);
                if (i > 0) {
                    sb.append(", ");
                }
                --i;
            }
        }
        return sb.toString();
    }
}

