/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util.collection;

import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.util.collection.ConcurrentExpiringMap;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;

public class LRUCache<K, V>
extends ConcurrentExpiringMap<K, V> {
    private final FastListenerList<DisposeListener> m_listenerList = new FastListenerList();

    public LRUCache(int targetSize, long timeToLive) {
        super(timeToLive, TimeUnit.MILLISECONDS, targetSize);
    }

    @Override
    public Set<K> keySet() {
        return new HashSet(super.keySet());
    }

    @Override
    public Collection<V> values() {
        return new HashSet(super.values());
    }

    @Override
    protected void execEntryEvicted(K key, V value) {
        this.fireValueDisposed(key, value);
    }

    @Override
    public V remove(Object key) {
        Object value = super.remove(key);
        if (value != null) {
            this.fireValueDisposed(key, value);
        }
        return value;
    }

    @Override
    public boolean remove(Object key, Object value) {
        boolean removed = super.remove(key, value);
        if (removed) {
            this.fireValueDisposed(key, value);
        }
        return removed;
    }

    @Override
    public V replace(K key, V value) {
        V oldValue = super.replace(key, value);
        if (oldValue != null) {
            this.fireValueDisposed(key, oldValue);
        }
        return oldValue;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        boolean replaced = super.replace(key, oldValue, newValue);
        if (replaced) {
            this.fireValueDisposed(key, oldValue);
        }
        return replaced;
    }

    @Override
    public void clear() {
        for (Map.Entry entry : this.entrySet()) {
            this.remove(entry.getKey(), entry.getValue());
        }
    }

    public FastListenerList<DisposeListener> disposeListeners() {
        return this.m_listenerList;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.disposeListeners().add(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.disposeListeners().remove(listener);
    }

    private void fireValueDisposed(Object key, Object value) {
        this.disposeListeners().list().forEach((? super T listener) -> listener.valueDisposed(key, value));
    }

    @FunctionalInterface
    public static interface DisposeListener
    extends EventListener {
        public void valueDisposed(Object var1, Object var2);
    }
}

