/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.nls.CollatorProvider;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.AlphanumericComparator;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public final class StringUtility {
    public static final Pattern PATTERN_TRIM_NEWLINES = Pattern.compile("^[\r\n]*(.*?)[\r\n]*$", 32);
    public static final String HTML_ENCODED_TAB = "<span style=\"white-space:pre\">&#9;</span>";
    public static final Comparator<String> ALPHANUMERIC_COMPARATOR = new AlphanumericComparator(false);
    public static final Comparator<String> ALPHANUMERIC_COMPARATOR_IGNORE_CASE = new AlphanumericComparator(true);
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Set<String> BOOLEAN_TRUE = new HashSet<String>(3);
    private static final Set<String> BOOLEAN_FALSE;
    private static final String CONVERT_UTF_ASCII_HEX_CHARS = "0123456789abcdef";
    public static final Pattern NEWLINE_PATTERN;
    private static final TagBounds TAG_BOUNDS_NOT_FOUND;
    public static boolean STRING_INTERN_ENABLED;

    static {
        BOOLEAN_TRUE.add("true");
        BOOLEAN_TRUE.add("yes");
        BOOLEAN_TRUE.add("1");
        BOOLEAN_FALSE = new HashSet<String>(3);
        BOOLEAN_FALSE.add("false");
        BOOLEAN_FALSE.add("no");
        BOOLEAN_FALSE.add("0");
        NEWLINE_PATTERN = Pattern.compile("[\\n\\r]+");
        TAG_BOUNDS_NOT_FOUND = new TagBounds(-1, -1);
        STRING_INTERN_ENABLED = true;
    }

    private StringUtility() {
    }

    public static boolean isNullOrEmpty(CharSequence s) {
        return s == null || s.length() == 0;
    }

    public static boolean hasText(CharSequence cs) {
        int len;
        if (cs == null || (len = cs.length()) == 0) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!Character.isWhitespace(cs.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String toRegExPattern(String wildcardPattern) {
        char[] ch;
        if (wildcardPattern == null) {
            wildcardPattern = "";
        }
        StringBuilder buf = new StringBuilder();
        char[] cArray = ch = wildcardPattern.toCharArray();
        int n = ch.length;
        int n2 = 0;
        while (n2 < n) {
            char aCh = cArray[n2];
            switch (aCh) {
                case ' ': {
                    buf.append(aCh);
                    break;
                }
                case '%': 
                case '*': {
                    buf.append(".*");
                    break;
                }
                case '?': 
                case '_': {
                    buf.append(".");
                    break;
                }
                case '$': 
                case '@': {
                    buf.append(".");
                    break;
                }
                case '<': 
                case '=': 
                case '>': {
                    buf.append(aCh);
                    break;
                }
                case '.': {
                    buf.append("\\.");
                    break;
                }
                default: {
                    if (aCh >= ' ' && (Character.isJavaIdentifierStart(aCh) || Character.isJavaIdentifierPart(aCh))) {
                        buf.append(aCh);
                        break;
                    }
                    buf.append('.');
                }
            }
            ++n2;
        }
        if (buf.length() > 0) {
            try {
                return Pattern.compile(buf.toString()).pattern();
            }
            catch (PatternSyntaxException ex) {
                return "INVALID_PATTERN";
            }
        }
        return ".*";
    }

    public static Pattern toRegEx(String humanReadableFilterText, int patternFlags) {
        if (humanReadableFilterText == null) {
            humanReadableFilterText = "";
        }
        if (humanReadableFilterText.indexOf(42) < 0) {
            humanReadableFilterText = String.valueOf(humanReadableFilterText) + "*";
        }
        return Pattern.compile(StringUtility.toRegExPattern(humanReadableFilterText), patternFlags);
    }

    public static String[] tokenize(String s, char c) {
        if (s == null) {
            return new String[0];
        }
        char[] cA = s.toCharArray();
        int count = 0;
        char[] cArray = cA;
        int n = cA.length;
        int n2 = 0;
        while (n2 < n) {
            char aCA = cArray[n2];
            if (aCA == c) {
                ++count;
            }
            ++n2;
        }
        String[] returnValue = new String[count + 1];
        int nextCindex = s.indexOf(c);
        count = 0;
        while (nextCindex >= 0) {
            returnValue[count++] = s.substring(0, nextCindex);
            s = s.substring(nextCindex + 1);
            nextCindex = s.indexOf(c);
        }
        returnValue[count++] = s;
        return returnValue;
    }

    public static boolean parseBoolean(String s, boolean defaultValue) {
        if (s == null || s.isEmpty()) {
            return defaultValue;
        }
        s = s.toLowerCase().trim();
        if (defaultValue) {
            return !BOOLEAN_FALSE.contains(s);
        }
        return BOOLEAN_TRUE.contains(s);
    }

    public static boolean parseBoolean(String s) {
        return StringUtility.parseBoolean(s, false);
    }

    public static int getLineCount(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        int r = 1;
        int pos = 0;
        while ((pos = s.indexOf(10, pos)) >= 0) {
            ++r;
            ++pos;
        }
        return r;
    }

    public static String[] getLines(String s) {
        int count = StringUtility.getLineCount(s);
        String[] lines = new String[count];
        if (count == 0) {
            return lines;
        }
        int index = 0;
        int begin = 0;
        int pos = 0;
        while ((pos = s.indexOf(10, pos)) >= 0) {
            String unit = s.substring(begin, pos);
            int ulen = unit.length();
            if (ulen > 0 && unit.charAt(0) == '\r') {
                unit = unit.substring(1);
            }
            if ((ulen = unit.length()) > 0 && unit.charAt(ulen - 1) == '\r') {
                unit = unit.substring(0, ulen - 1);
            }
            ulen = unit.length();
            lines[index] = unit;
            ++index;
            begin = ++pos;
        }
        lines[index] = s.substring(begin);
        return lines;
    }

    public static String stringEsc(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("[\"]", "\"\"");
        s = s.replaceAll("[']", "''");
        return s;
    }

    public static String stringUnesc(String s) {
        s = s.replaceAll("[\"][\"]", "\"");
        s = s.replaceAll("['][']", "'");
        return s;
    }

    public static String removeNewLines(String text) {
        return StringUtility.replaceNewLines(text, " ");
    }

    public static String replaceNewLines(String text, String replacement) {
        if (StringUtility.isNullOrEmpty(text)) {
            return text;
        }
        String s = text.replaceAll("\r\n|\n\r", replacement);
        s = s.replace("\n", replacement).replace("\r", replacement);
        return s;
    }

    private static TagBounds getSingleTag(String text, String tagName, int pos) {
        if (text == null) {
            return TAG_BOUNDS_NOT_FOUND;
        }
        Pattern pat = Pattern.compile("<" + tagName + "(\\s[^<>]*)?/>", 32);
        Matcher m = pat.matcher(text);
        if (m.find(pos)) {
            return new TagBounds(m.start(), m.end());
        }
        return TAG_BOUNDS_NOT_FOUND;
    }

    private static TagBounds getStartTag(String text, String tagName, boolean ignoreCase, int pos) {
        if (text == null) {
            return TAG_BOUNDS_NOT_FOUND;
        }
        int flags = ignoreCase ? 34 : 32;
        Pattern pat = Pattern.compile("<" + tagName + "(\\s[^<>]*[^/])?>", flags);
        Matcher m = pat.matcher(text);
        if (m.find(pos)) {
            return new TagBounds(m.start(), m.end());
        }
        return TAG_BOUNDS_NOT_FOUND;
    }

    private static TagBounds getEndTag(String text, String tagName, boolean ignoreCase, int pos) {
        if (text == null) {
            return TAG_BOUNDS_NOT_FOUND;
        }
        int flags = ignoreCase ? 2 : 0;
        Pattern pat = Pattern.compile("</" + tagName + ">", flags);
        Matcher m = pat.matcher(text);
        if (m.find(pos)) {
            return new TagBounds(m.start(), m.end());
        }
        return TAG_BOUNDS_NOT_FOUND;
    }

    public static String getTag(String text, String tagName) {
        return StringUtility.getTag(text, tagName, false);
    }

    public static String getTag(String text, String tagName, boolean ignoreCase) {
        if (text == null) {
            return null;
        }
        TagBounds a = StringUtility.getStartTag(text, tagName, ignoreCase, 0);
        if (a.begin >= 0) {
            TagBounds b = StringUtility.getEndTag(text, tagName, ignoreCase, a.end);
            if (b.begin >= 0) {
                return text.substring(a.end, b.begin).trim();
            }
        }
        a = StringUtility.getSingleTag(text, tagName, 0);
        if (a.begin >= 0) {
            return "";
        }
        return null;
    }

    public static String replaceTags(String text, String tagName, String replacement) {
        return StringUtility.replaceTags(text, tagName, false, replacement);
    }

    public static String replaceTags(String text, String tagName, boolean ignoreCase, String replacement) {
        return StringUtility.replaceTags(text, tagName, ignoreCase, (String name, String tagContent) -> replacement);
    }

    public static String replaceTags(String text, String tagName, ITagProcessor processor) {
        return StringUtility.replaceTags(text, tagName, false, processor);
    }

    /*
     * Unable to fully structure code
     */
    public static String replaceTags(String text, String tagName, boolean ignoreCase, ITagProcessor processor) {
        if (text != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            tagContent = "";
            replacement = processor.processTag(tagName, tagContent);
            text = String.valueOf(text.substring(0, a.begin)) + replacement + text.substring(a.end);
lbl6:
            // 2 sources

            a = StringUtility.getSingleTag(text, tagName, 0);
            ** while (a.begin >= 0)
        }
lbl8:
        // 1 sources

        if (true) ** GOTO lbl13
        do {
            tagContent = text.substring(a.end, b.begin);
            replacement = processor.processTag(tagName, tagContent);
            text = String.valueOf(text.substring(0, a.begin)) + replacement + text.substring(b.end);
lbl13:
            // 2 sources

            a = StringUtility.getStartTag(text, tagName, ignoreCase, 0);
            if (a.begin < 0) break;
            b = StringUtility.getEndTag(text, tagName, ignoreCase, a.end);
        } while (b.begin >= 0);
        return text;
    }

    public static String removeTag(String text, String tagName) {
        return StringUtility.removeTag(text, tagName, false);
    }

    /*
     * Unable to fully structure code
     */
    public static String removeTag(String text, String tagName, boolean ignoreCase) {
        if (text == null) {
            return null;
        }
        if (tagName != null) ** GOTO lbl6
        return text;
lbl-1000:
        // 1 sources

        {
            text = String.valueOf(text.substring(0, a.begin)) + text.substring(a.end);
lbl6:
            // 2 sources

            a = StringUtility.getSingleTag(text, tagName, 0);
            ** while (a.begin >= 0)
        }
lbl8:
        // 1 sources

        if (true) ** GOTO lbl11
        do {
            text = String.valueOf(text.substring(0, a.begin)) + text.substring(b.end);
lbl11:
            // 2 sources

            a = StringUtility.getStartTag(text, tagName, ignoreCase, 0);
            if (a.begin < 0) break;
            b = StringUtility.getEndTag(text, tagName, ignoreCase, a.end);
        } while (b.begin >= 0);
        return text;
    }

    public static String removeTags(String text, String[] tagNames) {
        if (text == null) {
            return null;
        }
        if (tagNames != null) {
            String[] stringArray = tagNames;
            int n = tagNames.length;
            int n2 = 0;
            while (n2 < n) {
                String tagName = stringArray[n2];
                text = StringUtility.removeTag(text, tagName);
                ++n2;
            }
        }
        return text;
    }

    public static String removeTags(String text) {
        if (text == null) {
            return null;
        }
        text = Pattern.compile("<[^>]+>", 32).matcher(text).replaceAll("");
        return text;
    }

    public static String removeTagBounds(String text, String tagName) {
        return StringUtility.removeTagBounds(text, tagName, false);
    }

    /*
     * Unable to fully structure code
     */
    public static String removeTagBounds(String text, String tagName, boolean ignoreCase) {
        if (text != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            text = String.valueOf(text.substring(0, a.begin)) + text.substring(a.end);
lbl4:
            // 2 sources

            a = StringUtility.getSingleTag(text, tagName, 0);
            ** while (a.begin >= 0)
        }
lbl6:
        // 1 sources

        if (true) ** GOTO lbl9
        do {
            text = String.valueOf(text.substring(0, a.begin)) + text.substring(a.end, b.begin) + text.substring(b.end);
lbl9:
            // 2 sources

            a = StringUtility.getStartTag(text, tagName, ignoreCase, 0);
            if (a.begin < 0) break;
            b = StringUtility.getEndTag(text, tagName, ignoreCase, a.end);
        } while (b.begin >= 0);
        return text;
    }

    public static String replaceTagBounds(String text, String tagName, String start, String end) {
        return StringUtility.replaceTagBounds(text, tagName, false, start, end);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static String replaceTagBounds(String text, String tagName, boolean ignoreCase, String start, String end) {
        int b;
        TagBounds a;
        if (text == null) {
            return null;
        }
        int startPos = 0;
        if (true) {
            return text;
        }
        do {
            text = String.valueOf(text.substring(0, a.begin)) + start + text.substring(a.end, b) + end + text.substring(b + tagName.length() + 3);
            startPos = a.begin + start.length();
            if (startPos >= text.length()) return text;
            a = StringUtility.getStartTag(text, tagName, ignoreCase, startPos);
        } while (a.begin >= 0 && (b = text.indexOf("</" + tagName + ">", a.end)) > 0);
        return text;
    }

    public static String wrapText(String s, int lineSize) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        char[] ch = s.toCharArray();
        int col = 0;
        char[] cArray = ch;
        int n = ch.length;
        int n2 = 0;
        while (n2 < n) {
            char aCh = cArray[n2];
            if (aCh == '\n' || aCh == '\r') {
                col = 0;
                buf.append(aCh);
            } else {
                if (++col > lineSize) {
                    buf.append('\n');
                    col = 1;
                }
                buf.append(aCh);
            }
            ++n2;
        }
        return buf.toString();
    }

    public static String wrapWord(String s, int lineSize) {
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String[] stringArray = s.split("[\\n\\r]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (buf.length() > 0) {
                buf.append("\n");
            }
            StringBuilder wrappedLine = new StringBuilder();
            String[] stringArray2 = line.split("[ \\t]");
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String word = stringArray2[n4];
                if (wrappedLine.length() > 0 && wrappedLine.length() + 1 + word.length() > lineSize) {
                    buf.append(wrappedLine.toString());
                    buf.append("\n");
                    wrappedLine.setLength(0);
                }
                if (wrappedLine.length() > 0) {
                    wrappedLine.append(" ");
                }
                wrappedLine.append(word);
                ++n4;
            }
            if (wrappedLine.length() > 0) {
                buf.append(StringUtility.wrapText(wrappedLine.toString(), lineSize));
            }
            ++n2;
        }
        return buf.toString().trim();
    }

    public static String unwrapText(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        s = s.replace('\n', ' ').replace('\r', ' ').replace('\t', ' ');
        s = s.replaceAll("[ ]+", " ");
        return s.trim();
    }

    public static boolean isQuotedText(CharSequence s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            return true;
        }
        return s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"';
    }

    public static String unquoteText(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = s.substring(1, s.length() - 1);
        } else if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String valueOf(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        if (o instanceof char[]) {
            return new String((char[])o);
        }
        return o.toString();
    }

    public static String className(Object o) {
        if (o == null) {
            return "";
        }
        String s = o.getClass().getName();
        int i = s.lastIndexOf(46);
        if (i >= 0) {
            return s.substring(i + 1);
        }
        return s;
    }

    public static String convertUTFAscii(String s, boolean escapeControlChars) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        int len = s.length();
        StringBuilder buf = new StringBuilder(len * 2);
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\t': {
                    if (escapeControlChars) {
                        buf.append("\\t");
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                case '\n': {
                    if (escapeControlChars) {
                        buf.append("\\n");
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                case '\r': {
                    if (escapeControlChars) {
                        buf.append("\\r");
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                case '\f': {
                    if (escapeControlChars) {
                        buf.append("\\f");
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        buf.append('\\');
                        buf.append('u');
                        buf.append(CONVERT_UTF_ASCII_HEX_CHARS.charAt(ch >> 12 & 0xF));
                        buf.append(CONVERT_UTF_ASCII_HEX_CHARS.charAt(ch >> 8 & 0xF));
                        buf.append(CONVERT_UTF_ASCII_HEX_CHARS.charAt(ch >> 4 & 0xF));
                        buf.append(CONVERT_UTF_ASCII_HEX_CHARS.charAt(ch & 0xF));
                        break;
                    }
                    buf.append(ch);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String convertAsciiUTF(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        int len = s.length();
        StringBuilder buf = new StringBuilder(len);
        int k = 0;
        while (k < len) {
            char ch;
            if ((ch = s.charAt(k++)) == '\\') {
                if ((ch = s.charAt(k++)) == 'u') {
                    int value = Integer.parseInt(s.substring(k, k + 4), 16);
                    k += 4;
                    buf.append((char)value);
                    continue;
                }
                switch (ch) {
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case 'f': {
                        buf.append('\f');
                        break;
                    }
                    default: {
                        buf.append(ch);
                        break;
                    }
                }
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String emptyIfNull(Object o) {
        return o == null ? "" : o.toString();
    }

    public static String nullIfEmpty(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence && ((CharSequence)o).length() == 0) {
            return null;
        }
        return o.toString();
    }

    public static String chr(int code) {
        return "" + (char)Math.min(Math.max(code, 0), 255);
    }

    public static int asc(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        return s.charAt(0);
    }

    public static String cleanup(String s) {
        return StringUtility.unwrapText(s);
    }

    public static Object decode(Object ... a) {
        Object ref = a[0];
        int i = 1;
        int n = a.length;
        while (i < n) {
            if (i + 1 < n) {
                Object test = a[i];
                if (ref == test || ref != null && ref.equals(test)) {
                    return a[i + 1];
                }
            } else {
                return a[i];
            }
            i += 2;
        }
        return null;
    }

    public static boolean equalsIgnoreCase(String a, String b) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        return a.equalsIgnoreCase(b);
    }

    public static boolean notEqualsIgnoreCase(String a, String b) {
        if (a == null) {
            a = "";
        }
        if (b == null) {
            b = "";
        }
        return !a.equalsIgnoreCase(b);
    }

    public static boolean equalsIgnoreNewLines(String a, String b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        return NEWLINE_PATTERN.matcher(a).replaceAll(" ").equals(NEWLINE_PATTERN.matcher(b).replaceAll(" "));
    }

    public static boolean containsNewLines(String s) {
        return s != null && (s.indexOf(10) >= 0 || s.indexOf(13) >= 0);
    }

    public static String filterText(String text, String allowedCharacters, String replacementText) {
        if (text == null || allowedCharacters == null) {
            return text;
        }
        if (replacementText == null) {
            replacementText = "";
        }
        return text.replaceAll("[^" + allowedCharacters + "]", replacementText);
    }

    public static int find(String s, String what) {
        return StringUtility.find(s, what, 0);
    }

    public static int find(String s, String what, int start) {
        if (s == null || start >= s.length()) {
            return -1;
        }
        return s.indexOf(what, start);
    }

    public static String formatPhone(String phoneNumber, String formattingPattern, String countryCode) {
        if (phoneNumber == null) {
            return null;
        }
        if (formattingPattern == null) {
            return phoneNumber;
        }
        if (countryCode == null) {
            return phoneNumber;
        }
        char numberPattern = "#".charAt(0);
        String formattedPhoneNumber = "";
        boolean patternIsMatching = false;
        boolean hasCountryCode = false;
        int patternLengh = formattingPattern.replaceAll("[^#]", "").length();
        String normalizedNumber = phoneNumber.replaceAll("[^(0-9|\\+)]|(\\(|\\))", "");
        hasCountryCode = normalizedNumber.matches("(^(0{2})[0-9]*)|(^\\+{1}[0-9]*)");
        countryCode = countryCode.replaceAll("[^0-9]", "");
        countryCode = countryCode.replaceAll("^(0{0,2})", "");
        if (hasCountryCode) {
            normalizedNumber = normalizedNumber.replaceAll("^(0{0,2})", "");
            normalizedNumber = normalizedNumber.replaceAll("^(\\+)", "");
            normalizedNumber = normalizedNumber.replaceAll("^" + countryCode, "");
        }
        if (patternLengh == normalizedNumber.length() + 1 && !normalizedNumber.startsWith("0")) {
            normalizedNumber = "0" + normalizedNumber;
            patternIsMatching = true;
        } else if (patternLengh == normalizedNumber.length()) {
            patternIsMatching = true;
        }
        if (patternIsMatching) {
            int count = 0;
            int i = 0;
            while (i < formattingPattern.length()) {
                if (formattingPattern.charAt(i) == numberPattern) {
                    if (count < normalizedNumber.length()) {
                        formattedPhoneNumber = String.valueOf(formattedPhoneNumber) + normalizedNumber.charAt(count);
                        ++count;
                    }
                } else {
                    formattedPhoneNumber = String.valueOf(formattedPhoneNumber) + formattingPattern.charAt(i);
                }
                ++i;
            }
            formattedPhoneNumber = formattedPhoneNumber.replaceAll("^[0]+", "");
            formattedPhoneNumber = "+" + countryCode + " " + formattedPhoneNumber;
        } else {
            formattedPhoneNumber = phoneNumber;
        }
        return formattedPhoneNumber;
    }

    public static int length(CharSequence s) {
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    public static String lowercase(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase();
    }

    public static String uppercase(String s) {
        if (s == null) {
            return null;
        }
        return s.toUpperCase();
    }

    public static String uppercaseFirst(String s) {
        if (StringUtility.isNullOrEmpty(s)) {
            return s;
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static String[] split(String s, String regex) {
        if (StringUtility.isNullOrEmpty(s)) {
            return new String[0];
        }
        return s.split(regex);
    }

    public static String[] split(String s, String regex, int limit) {
        if (StringUtility.isNullOrEmpty(s)) {
            return new String[0];
        }
        return s.split(regex, limit);
    }

    public static String splitCamelCase(String s) {
        if (!StringUtility.hasText(s)) {
            return null;
        }
        return s.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public static String substring(String s, int start) {
        if (s == null || start >= s.length()) {
            return "";
        }
        return s.substring(start);
    }

    public static String substring(String s, int start, int len) {
        if (s == null || start >= s.length()) {
            return "";
        }
        len = Math.min(s.length() - start, len);
        return s.substring(start, start + len);
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    public static String trimNewLines(String s) {
        if (s == null) {
            return null;
        }
        Matcher matcher = PATTERN_TRIM_NEWLINES.matcher(s);
        if (matcher.find()) {
            s = matcher.group(1);
        }
        return s;
    }

    public static String lpad(String s, String fill, int len) {
        if (s == null || fill == null || s.length() >= len || fill.isEmpty()) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s);
        while (buf.length() < len) {
            buf.insert(0, fill);
        }
        return buf.substring(buf.length() - len, buf.length());
    }

    public static String rpad(String s, String fill, int len) {
        if (s == null || fill == null || s.length() >= len || fill.isEmpty()) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s);
        while (buf.length() < len) {
            buf.append(fill);
        }
        return buf.substring(0, len);
    }

    public static String ltrim(String s, Character c) {
        if (s == null) {
            return null;
        }
        if (c == null) {
            return s;
        }
        int len = s.length();
        int st = 0;
        char[] val = s.toCharArray();
        while (st < len && val[st] == c.charValue()) {
            ++st;
        }
        return st > 0 || len < s.length() ? s.substring(st, len) : s;
    }

    public static String rtrim(String s, Character c) {
        if (s == null) {
            return null;
        }
        if (c == null) {
            return s;
        }
        int len = s.length();
        int st = 0;
        char[] val = s.toCharArray();
        while (st < len && val[len - 1] == c.charValue()) {
            --len;
        }
        return st > 0 || len < s.length() ? s.substring(st, len) : s;
    }

    public static String replace(String source, String search, String replacement) {
        if (source == null || source.length() < 1 || search == null || search.length() < 1) {
            return source;
        }
        if (replacement == null) {
            replacement = "";
        }
        int searchLength = search.length();
        StringBuilder result = new StringBuilder(source.length());
        int lastPos = 0;
        int occurrenceIndex = source.indexOf(search, lastPos);
        while (occurrenceIndex >= 0) {
            result.append(source.substring(lastPos, occurrenceIndex)).append(replacement);
            lastPos = occurrenceIndex + searchLength;
            occurrenceIndex = source.indexOf(search, lastPos);
        }
        result.append(source.substring(lastPos));
        return result.toString();
    }

    public static String replaceNoCase(String s, String sOld, String sNew) {
        if (s == null || sOld == null || sNew == null) {
            return s;
        }
        StringBuilder buf = new StringBuilder();
        int oldLen = sOld.length();
        int pos = 0;
        sOld = sOld.toLowerCase();
        String sLower = s.toLowerCase();
        int i = sLower.indexOf(sOld);
        while (i >= 0) {
            buf.append(s.substring(pos, i));
            buf.append(sNew);
            pos = i + oldLen;
            i = sLower.indexOf(sOld, pos);
        }
        buf.append(s.substring(pos));
        return buf.toString();
    }

    public static String unescapeWhitespace(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\\\\n", "\n");
        s = s.replaceAll("\\\\t", "\t");
        s = s.replaceAll("\\\\r", "\r");
        s = s.replaceAll("\\\\b", "\b");
        s = s.replaceAll("\\\\f", "\f");
        return s;
    }

    public static String escapeWhitespace(String s) {
        if (s == null) {
            return null;
        }
        s = s.replaceAll("\n", "\\\\n");
        s = s.replaceAll("\t", "\\\\t");
        s = s.replaceAll("\r", "\\\\r");
        s = s.replaceAll("\b", "\\\\b");
        s = s.replaceAll("\f", "\\\\f");
        return s;
    }

    public static String join(String delimiter, Object ... parts) {
        if (parts == null || parts.length == 0) {
            return "";
        }
        boolean added = false;
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String s;
            Object o = objectArray[n2];
            if (o != null && !StringUtility.isNullOrEmpty(s = o.toString())) {
                if (added && delimiter != null) {
                    builder.append(delimiter);
                }
                builder.append(s);
                added = true;
            }
            ++n2;
        }
        return builder.toString();
    }

    public static String join(String delimiter, Long[] parts) {
        return StringUtility.join(delimiter, (Object[])parts);
    }

    public static String join(String delimiter, String[] parts) {
        return StringUtility.join(delimiter, (Object[])parts);
    }

    public static String join(String delimiter, Collection<?> parts) {
        return StringUtility.join(delimiter, parts == null ? EMPTY_ARRAY : parts.toArray());
    }

    public static String box(String prefix, String s, String suffix) {
        StringBuilder builder = new StringBuilder();
        if (StringUtility.hasText(s)) {
            if (!StringUtility.isNullOrEmpty(prefix)) {
                builder.append(prefix);
            }
            builder.append(s);
            if (!StringUtility.isNullOrEmpty(suffix)) {
                builder.append(suffix);
            }
        }
        return builder.toString();
    }

    public static String removeSuffixes(String s, String ... suffixes) {
        int i = suffixes.length - 1;
        while (i >= 0) {
            if (suffixes[i] != null && s.toLowerCase().endsWith(suffixes[i].toLowerCase())) {
                s = s.substring(0, s.length() - suffixes[i].length());
            }
            --i;
        }
        return s;
    }

    public static byte[] compress(String s) {
        ByteArrayOutputStream buffer;
        block39: {
            buffer = new ByteArrayOutputStream();
            Deflater deflater = new Deflater(9);
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)buffer, deflater);
            StringReader in = null;
            try {
                try {
                    int len;
                    in = new StringReader(s);
                    char[] c = new char[102400];
                    while ((len = in.read(c)) > 0) {
                        String str = new String(c, 0, len);
                        byte[] b = str.getBytes(StandardCharsets.UTF_8);
                        deflaterOutputStream.write(b, 0, b.length);
                    }
                }
                catch (IOException iOException) {
                    try {
                        deflaterOutputStream.flush();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    try {
                        buffer.flush();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                    deflater.finish();
                    try {
                        deflaterOutputStream.finish();
                    }
                    catch (IOException iOException4) {
                        // empty catch block
                    }
                    deflater.end();
                    try {
                        deflaterOutputStream.close();
                    }
                    catch (IOException iOException5) {
                        // empty catch block
                    }
                    try {
                        buffer.close();
                    }
                    catch (IOException iOException6) {
                        // empty catch block
                    }
                    if (in != null) {
                        in.close();
                    }
                    break block39;
                }
            }
            catch (Throwable throwable) {
                try {
                    deflaterOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    buffer.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                deflater.finish();
                try {
                    deflaterOutputStream.finish();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                deflater.end();
                try {
                    deflaterOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    buffer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (in != null) {
                    in.close();
                }
                throw throwable;
            }
            try {
                deflaterOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                buffer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            deflater.finish();
            try {
                deflaterOutputStream.finish();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            deflater.end();
            try {
                deflaterOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                buffer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (in != null) {
                in.close();
            }
        }
        return buffer.toByteArray();
    }

    public static String decompress(byte[] compressed) {
        StringWriter out;
        block24: {
            ByteArrayInputStream in = new ByteArrayInputStream(compressed);
            Inflater inflater = new Inflater();
            InflaterInputStream inflaterInputStream = new InflaterInputStream(in, inflater);
            out = new StringWriter();
            try {
                try {
                    int len;
                    InputStreamReader reader = new InputStreamReader((InputStream)inflaterInputStream, StandardCharsets.UTF_8.name());
                    char[] b = new char[102400];
                    while ((len = reader.read(b)) > 0) {
                        String str = new String(b, 0, len);
                        out.write(str, 0, str.length());
                    }
                }
                catch (IOException iOException) {
                    try {
                        inflaterInputStream.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    inflater.end();
                    out.flush();
                    try {
                        in.close();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (IOException iOException4) {}
                    break block24;
                }
            }
            catch (Throwable throwable) {
                try {
                    inflaterInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                inflater.end();
                out.flush();
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                inflaterInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inflater.end();
            out.flush();
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return out.toString();
    }

    public static String removePrefixes(String s, String ... prefixes) {
        String[] stringArray = prefixes;
        int n = prefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefixe = stringArray[n2];
            if (prefixe != null && s.toLowerCase().startsWith(prefixe.toLowerCase())) {
                s = s.substring(prefixe.length());
            }
            ++n2;
        }
        return s;
    }

    public static String concatenateTokens(String ... s) {
        String retVal = "";
        if (s != null && s.length > 0) {
            StringBuilder b = new StringBuilder();
            String suffix = s[0];
            if (StringUtility.hasText(suffix)) {
                b.append(suffix.trim());
            }
            int i = 1;
            int l = s.length - 1;
            while (i < l) {
                String del = s[i];
                suffix = s[i + 1];
                if (StringUtility.hasText(suffix)) {
                    if (b.length() > 0) {
                        b.append(del);
                    }
                    b.append(suffix.trim());
                }
                i += 2;
            }
            retVal = b.toString().trim();
            if (s.length % 2 == 0 && !retVal.isEmpty()) {
                retVal = String.valueOf(retVal) + s[s.length - 1];
            }
        }
        return retVal;
    }

    public static Collection<Object> stringToCollection(String text) {
        return CollectionUtility.parse(text);
    }

    public static String collectionToString(Collection<Object> c) {
        return StringUtility.collectionToString(c, false);
    }

    public static String collectionToString(Collection<Object> c, boolean quoteStrings) {
        return CollectionUtility.format(c, quoteStrings);
    }

    public static int compareIgnoreCase(String a, String b) {
        return StringUtility.compareIgnoreCase(NlsLocale.get(), a, b);
    }

    public static int compareIgnoreCase(Locale locale, String a, String b) {
        return StringUtility.compare(1, locale, a, b);
    }

    public static int compare(String a, String b) {
        return StringUtility.compare(2, NlsLocale.get(), a, b);
    }

    public static int compare(int strength, Locale locale, String a, String b) {
        if (a != null && a.isEmpty()) {
            a = null;
        }
        if (b != null && b.isEmpty()) {
            b = null;
        }
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Collator collator = BEANS.get(CollatorProvider.class).getInstance(locale);
        collator.setStrength(strength);
        return collator.compare(a, b);
    }

    public static String intern(String s) {
        if (STRING_INTERN_ENABLED) {
            return s != null ? s.intern() : null;
        }
        return s;
    }

    public static String repeat(CharSequence token, int repetitions) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < repetitions) {
            sb.append(token);
            ++i;
        }
        return sb.toString();
    }

    public static String formatNanos(long nanos) {
        String x = "" + nanos;
        if (nanos < 0L) {
            x = x.substring(1);
        }
        x = StringUtility.lpad(x, "0", 7);
        return String.valueOf(nanos < 0L ? "-" : "") + x.substring(0, x.length() - 6) + "." + x.substring(x.length() - 6);
    }

    public static String escapeRegexMetachars(CharSequence s) {
        if (s == null) {
            s = "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '<': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': {
                    sb.append('\\');
                    break;
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static boolean startsWith(String s, String prefix) {
        if (s == null || prefix == null) {
            return false;
        }
        return s.startsWith(prefix);
    }

    public static boolean startsWith(String s, String prefix, int toffset) {
        if (s == null || prefix == null) {
            return false;
        }
        return s.startsWith(prefix, toffset);
    }

    public static boolean endsWith(String s, String suffix) {
        if (s == null || suffix == null) {
            return false;
        }
        return s.endsWith(suffix);
    }

    public static boolean containsString(String s, String substr) {
        if (s == null || substr == null) {
            return false;
        }
        return s.contains(substr);
    }

    public static boolean containsStringIgnoreCase(String s, String substr) {
        if (s == null || substr == null) {
            return false;
        }
        int lenS = s.length();
        int lenSubstr = substr.length();
        if (lenSubstr > lenS) {
            return false;
        }
        int i = 0;
        while (i <= lenS - lenSubstr) {
            boolean matches = s.regionMatches(true, i, substr, 0, lenSubstr);
            if (matches) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsRegEx(String s, String regex) {
        return StringUtility.containsRegEx(s, regex, 40);
    }

    public static boolean containsRegEx(String s, String regex, int flags) {
        if (s == null || regex == null) {
            return false;
        }
        Pattern p = Pattern.compile(".*" + regex + ".*", flags);
        return p.matcher(s).matches();
    }

    public static boolean matches(String s, String regex) {
        if (s == null || regex == null) {
            return false;
        }
        return s.matches(regex);
    }

    public static boolean matches(String s, String regex, int flags) {
        if (s == null || regex == null) {
            return false;
        }
        return Pattern.compile(regex, flags).matcher(s).matches();
    }

    public static int indexOf(String s, int ch) {
        return s == null ? -1 : s.indexOf(ch);
    }

    public static int indexOf(String s, String str) {
        return s == null || str == null ? -1 : s.indexOf(str);
    }

    public static int indexOf(String s, int ch, int fromIndex) {
        return s == null ? -1 : s.indexOf(ch, fromIndex);
    }

    public static int indexOf(String s, String str, int fromIndex) {
        return s == null || str == null ? -1 : s.indexOf(str, fromIndex);
    }

    public static int lastIndexOf(String s, int ch) {
        return s == null ? -1 : s.lastIndexOf(ch);
    }

    public static int lastIndexOf(String s, String str) {
        return s == null || str == null ? -1 : s.lastIndexOf(str);
    }

    public static int lastIndexOf(String s, int ch, int fromIndex) {
        return s == null ? -1 : s.lastIndexOf(ch, fromIndex);
    }

    public static int lastIndexOf(String s, String str, int fromIndex) {
        return s == null || str == null ? -1 : s.lastIndexOf(str, fromIndex);
    }

    @FunctionalInterface
    public static interface ITagProcessor {
        public String processTag(String var1, String var2);
    }

    private static class TagBounds {
        final int begin;
        final int end;

        public TagBounds(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            return ((TagBounds)o).begin == this.begin && ((TagBounds)o).end == this.end;
        }

        public int hashCode() {
            return this.begin ^ this.end;
        }
    }
}

