/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class StreamUtility {
    private StreamUtility() {
    }

    public static <T> Predicate<T> not(Predicate<T> p) {
        return p.negate();
    }

    public static <T> Stream<T> iterate(final T initialElement, final Predicate<? super T> hasNext, final UnaryOperator<T> next) {
        Assertions.assertNotNull(next);
        Assertions.assertNotNull(hasNext);
        Spliterators.AbstractSpliterator spliterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            private T m_prev;
            private boolean m_started;
            private boolean m_exhausted;

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Object currentElement;
                Objects.requireNonNull(action);
                if (this.m_exhausted) {
                    return false;
                }
                if (this.m_started) {
                    currentElement = next.apply(this.m_prev);
                } else {
                    currentElement = initialElement;
                    this.m_started = true;
                }
                if (!hasNext.test(currentElement)) {
                    this.m_prev = null;
                    this.m_exhausted = true;
                    return false;
                }
                this.m_prev = currentElement;
                action.accept(currentElement);
                return true;
            }

            @Override
            public void forEachRemaining(Consumer<? super T> action) {
                Assertions.assertNotNull(action);
                if (this.m_exhausted) {
                    return;
                }
                this.m_exhausted = true;
                Object currentElement = this.m_started ? next.apply(this.m_prev) : initialElement;
                this.m_prev = null;
                while (hasNext.test(currentElement)) {
                    action.accept(currentElement);
                    currentElement = next.apply(currentElement);
                }
            }
        };
        return StreamSupport.stream(spliterator, false);
    }

    public static <T> Stream<T> takeWhile(Stream<T> stream, final Predicate<? super T> predicate) {
        Assertions.assertNotNull(predicate);
        final Spliterator streamSpliterator = Assertions.assertNotNull(stream).spliterator();
        Spliterators.AbstractSpliterator takeWhileSpleiterator = new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 1040){
            private boolean m_exhausted;

            @Override
            public Spliterator<T> trySplit() {
                return null;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                Assertions.assertNotNull(action);
                if (this.m_exhausted) {
                    return false;
                }
                return streamSpliterator.tryAdvance(t -> {
                    if (predicate.test(t)) {
                        action.accept(t);
                    } else {
                        this.m_exhausted = true;
                    }
                });
            }
        };
        return StreamSupport.stream(takeWhileSpleiterator, false);
    }

    public static <T> Collector<T, ?, LinkedList<T>> toReverseList() {
        return Collector.of(LinkedList::new, (l, b) -> l.addFirst(b), (l1, l2) -> {
            l2.addAll(l1);
            return l2;
        }, new Collector.Characteristics[0]);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return StreamUtility.toMap(HashMap::new, keyMapper, valueMapper, StreamUtility.throwingMerger(), new Collector.Characteristics[0]);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Supplier<M> mapSupplier, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return StreamUtility.toMap(mapSupplier, keyMapper, valueMapper, StreamUtility.throwingMerger(), new Collector.Characteristics[0]);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BiFunction<? super U, ? super U, ? extends U> remappingFunction) {
        return StreamUtility.toMap(HashMap::new, keyMapper, valueMapper, remappingFunction, new Collector.Characteristics[0]);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Supplier<M> mapSupplier, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BiFunction<? super U, ? super U, ? extends U> remappingFunction, Collector.Characteristics ... characteristics) {
        return Collector.of(mapSupplier, (map, value) -> StreamUtility.putEntry(map, keyMapper.apply(value), valueMapper.apply(value), remappingFunction), (map1, map2) -> StreamUtility.mergeMap(map1, map2, remappingFunction), characteristics);
    }

    private static <K, U, M extends Map<K, U>> M mergeMap(M map1, M map2, BiFunction<? super U, ? super U, ? extends U> remappingFunction) {
        map2.forEach((k, u) -> StreamUtility.putEntry(map1, k, u, remappingFunction));
        return map1;
    }

    private static <K, U> void putEntry(Map<K, U> map, K key, U value, BiFunction<? super U, ? super U, ? extends U> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        U newValue = value;
        if (map.containsKey(key)) {
            U oldValue = map.get(key);
            newValue = remappingFunction.apply(oldValue, value);
        }
        map.put(key, newValue);
    }

    public static <T, K, U> Collector<T, ?, LinkedHashMap<K, U>> toLinkedHashMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return StreamUtility.toMap(LinkedHashMap::new, keyMapper, valueMapper);
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public static <T> BinaryOperator<T> ignoringMerger() {
        return (u, v) -> u;
    }

    public static <T> BinaryOperator<T> replacingMerger() {
        return (u, v) -> v;
    }
}

