/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.nio.file.Path;
import java.util.Locale;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.resource.MimeType;
import org.eclipse.scout.rt.platform.util.IMimeTypeDetector;

@Order(value=0.0)
@ApplicationScoped
public class PrimaryMimeTypeDetector
implements IMimeTypeDetector {
    @Override
    public String getMimeType(Path path) {
        if (path == null) {
            return null;
        }
        Path fileName = path.getFileName();
        if (fileName == null) {
            return null;
        }
        String name = fileName.toString();
        int dot = name.lastIndexOf(46);
        if (dot < 0) {
            return null;
        }
        String ext = name.substring(dot + 1).toLowerCase(Locale.US);
        return this.fileExtensionToMimeType(ext);
    }

    protected String fileExtensionToMimeType(String ext) {
        MimeType mimeType = MimeType.findByFileExtension(ext);
        if (mimeType != null) {
            return mimeType.getType();
        }
        return null;
    }
}

