/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

public class PreferredValue<VALUE> {
    private VALUE m_value;
    private boolean m_preferred;

    public PreferredValue(VALUE value, boolean preferred) {
        this.m_value = value;
        this.m_preferred = preferred;
    }

    public boolean set(VALUE value, boolean preferred) {
        if (preferred) {
            this.m_preferred = true;
        }
        if (preferred || !this.m_preferred) {
            this.m_value = value;
            return true;
        }
        return false;
    }

    public VALUE get() {
        return this.m_value;
    }

    public boolean isPreferredValue() {
        return this.m_preferred;
    }

    public void markAsPreferredValue() {
        this.m_preferred = true;
    }

    public PreferredValue<VALUE> copy() {
        return new PreferredValue<VALUE>(this.m_value, this.m_preferred);
    }
}

