/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.BinaryResources;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtility {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtility.class);
    public static final int BUFFER_SIZE = 10240;

    private IOUtility() {
    }

    public static byte[] getContent(String filename) {
        return IOUtility.getContent(Assertions.assertNotNull(IOUtility.toFile(filename)));
    }

    public static byte[] getContent(File file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream in = new FileInputStream(file);){
                return IOUtility.readBytes(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("filename: " + file.getAbsolutePath(), new Object[]{e});
        }
    }

    public static String getContentInEncoding(String filepath, String encoding) {
        return IOUtility.getContentInEncoding(IOUtility.toFile(filepath), encoding);
    }

    public static String getContentInEncoding(File file, String encoding) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in = new FileInputStream(file);){
                return IOUtility.readString(in, encoding);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProcessingException(e.getMessage(), new Object[]{e});
        }
    }

    public static byte[] readBytes(InputStream in) {
        return IOUtility.readBytes(in, -1);
    }

    public static byte[] readBytes(InputStream in, int len) {
        if (len >= 0) {
            try {
                byte[] buf = new byte[len];
                int count = 0;
                while (count < len) {
                    int read = in.read(buf, count, len - count);
                    if (read < 0) {
                        return Arrays.copyOf(buf, count);
                    }
                    count += read;
                }
                return buf;
            }
            catch (IOException e) {
                throw new ProcessingException("input: " + in, new Object[]{e});
            }
        }
        try {
            Throwable e = null;
            Object var3_8 = null;
            try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                IOUtility.writeFromToStream(buffer, in);
                return buffer.toByteArray();
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("input: " + in, new Object[]{e});
        }
    }

    public static String readString(InputStream in, String charset) {
        return IOUtility.readString(in, charset, -1);
    }

    public static String readStringUTF8(InputStream in) {
        return IOUtility.readString(in, StandardCharsets.UTF_8.name(), -1);
    }

    public static String readString(InputStream in, String charset, int len) {
        if (StringUtility.hasText(charset)) {
            try {
                return IOUtility.readString(new InputStreamReader(in, charset), len);
            }
            catch (UnsupportedEncodingException e) {
                throw new PlatformException("charset {}", charset, e);
            }
        }
        return IOUtility.readString(new InputStreamReader(in), len);
    }

    public static String readString(Reader in) {
        return IOUtility.readString(in, -1);
    }

    public static String readString(Reader in, int maxLen) {
        if (maxLen >= 0) {
            try {
                char[] buf = new char[maxLen];
                int count = 0;
                int nRead = in.read(buf, 0, maxLen);
                while (nRead != -1 && count < maxLen) {
                    nRead = in.read(buf, count += nRead, maxLen - count);
                }
                return new String(buf, 0, count);
            }
            catch (IOException e) {
                throw new ProcessingException("input: " + in, new Object[]{e});
            }
        }
        try {
            Throwable e = null;
            Object var3_8 = null;
            try (StringWriter buffer = new StringWriter();){
                int k;
                char[] b = new char[10240];
                while ((k = in.read(b)) > 0) {
                    buffer.write(b, 0, k);
                }
                return buffer.toString();
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("input: " + in, new Object[]{e});
        }
    }

    public static byte[] compressGzip(byte[] b) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (GZIPOutputStream out = new GZIPOutputStream(buf);){
            out.write(b);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return buf.toByteArray();
    }

    public static byte[] uncompressGzip(byte[] b) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(b)));){
            int val;
            while ((val = in.read()) >= 0) {
                out.write(val);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return out.toByteArray();
    }

    public static Collection<BinaryResource> unzip(byte[] zipArchive, Pattern filterPattern) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zipArchive));){
            ZipEntry entry;
            ArrayList<BinaryResource> list = new ArrayList<BinaryResource>();
            while ((entry = zis.getNextEntry()) != null) {
                if (filterPattern != null && !filterPattern.matcher(entry.getName()).matches() || entry.isDirectory()) continue;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtility.writeFromToStream(bos, zis);
                bos.close();
                BinaryResource res = BinaryResources.create().withFilename(entry.getName()).withContent(bos.toByteArray()).withLastModified(entry.getTime()).build();
                list.add(res);
            }
            return list;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] readFromUrl(URL url) throws IOException {
        URLConnection uc = url.openConnection();
        int len = uc.getContentLength();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream in = new BufferedInputStream(uc.getInputStream());){
            return IOUtility.readBytes(in, len);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeContent(String filename, Object o) {
        block31: {
            File f = IOUtility.toFile(filename);
            try {
                if (o instanceof byte[]) {
                    Throwable throwable = null;
                    Object var4_10 = null;
                    try (FileOutputStream out = new FileOutputStream(f);){
                        IOUtility.writeBytes(out, (byte[])o);
                        break block31;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (o instanceof char[]) {
                    Throwable throwable = null;
                    Object var4_12 = null;
                    try (FileWriter out = new FileWriter(f);){
                        IOUtility.writeString(out, new String((char[])o));
                        break block31;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                if (o == null) break block31;
                Throwable throwable = null;
                Object var4_14 = null;
                try (FileWriter out = new FileWriter(f);){
                    IOUtility.writeString(out, o.toString());
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new ProcessingException("filename: " + filename, new Object[]{e});
            }
        }
    }

    public static void writeBytes(OutputStream out, byte[] bytes) {
        try {
            out.write(bytes);
        }
        catch (IOException e) {
            throw new ProcessingException("output: " + out, new Object[]{e});
        }
    }

    public static long writeFromToStream(OutputStream out, InputStream in) throws IOException {
        int numRead = 0;
        long count = 0L;
        byte[] data = new byte[10240];
        while ((numRead = in.read(data)) > 0) {
            out.write(data, 0, numRead);
            count += (long)numRead;
        }
        return count;
    }

    public static void writeStringUTF8(OutputStream out, String s) {
        IOUtility.writeString(out, StandardCharsets.UTF_8.name(), s);
    }

    public static void writeString(OutputStream out, String charset, String s) {
        try {
            OutputStreamWriter w = new OutputStreamWriter(out, charset);
            w.write(s);
            w.flush();
        }
        catch (IOException e) {
            throw new ProcessingException("output: " + out, new Object[]{e});
        }
    }

    public static void writeString(Writer out, String s) {
        try {
            out.write(s);
        }
        catch (IOException e) {
            throw new ProcessingException("output: " + out, new Object[]{e});
        }
    }

    public static File[] listFilesInSubtree(File dir, FileFilter filter) {
        ArrayList<File> list = new ArrayList<File>();
        IOUtility.listFilesRec(dir, filter, list);
        return list.toArray(new File[list.size()]);
    }

    private static void listFilesRec(File dir, FileFilter filter, ArrayList<File> intoList) {
        if (dir != null && dir.exists() && dir.isDirectory()) {
            File[] a = dir.listFiles(filter);
            int i = 0;
            while (a != null && i < a.length) {
                if (a[i].isDirectory()) {
                    IOUtility.listFilesRec(a[i], filter, intoList);
                } else {
                    intoList.add(a[i]);
                }
                ++i;
            }
        }
    }

    public static File createTempDirectory(String dirSuffix) {
        try {
            if (dirSuffix != null) {
                dirSuffix = dirSuffix.replaceAll("[:*?\\\"<>|]*", "");
            }
            File tmp = File.createTempFile("dir", dirSuffix);
            tmp.delete();
            tmp.mkdirs();
            tmp.deleteOnExit();
            return tmp;
        }
        catch (IOException e) {
            throw new ProcessingException("dir: " + dirSuffix, new Object[]{e});
        }
    }

    public static File createTempFile(String fileName, byte[] content) {
        try {
            File f2;
            block16: {
                File f;
                if (fileName != null) {
                    fileName = fileName.replaceAll("[\\\\/:*?\\\"<>|]*", "");
                }
                if (fileName == null || fileName.isEmpty()) {
                    fileName = IOUtility.getTempFileName(".tmp");
                }
                if ((f2 = new File((f = File.createTempFile("tmp", ".tmp")).getParentFile(), new File(fileName).getName())).exists() && !f2.delete()) {
                    throw new IOException("File " + f2 + " exists and cannot be deleted");
                }
                boolean ok = f.renameTo(f2);
                if (!ok) {
                    throw new IOException("failed renaming " + f + " to " + f2);
                }
                f2.deleteOnExit();
                if (content != null) {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (FileOutputStream out = new FileOutputStream(f2);){
                        IOUtility.writeBytes(out, content);
                        break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                f2.createNewFile();
            }
            return f2;
        }
        catch (IOException e) {
            throw new ProcessingException("filename: " + fileName, new Object[]{e});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File createTempFile(InputStream content, String filename, String extension) {
        try {
            File temp = File.createTempFile(filename, extension);
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                InputStream in = content;
                try {
                    try (FileOutputStream out = new FileOutputStream(temp);){
                        IOUtility.writeBytes(out, IOUtility.readBytes(in));
                    }
                    if (in == null) return temp;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return temp;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Error creating temp file", new Object[]{e});
        }
    }

    public static File createTempFile(String prefix, String suffix, byte[] content) {
        File f = null;
        try {
            f = File.createTempFile(prefix, suffix);
            f.deleteOnExit();
            if (content != null) {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileOutputStream out = new FileOutputStream(f);){
                    IOUtility.writeBytes(out, content);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return f;
        }
        catch (IOException e) {
            throw new ProcessingException("filename: " + f, new Object[]{e});
        }
    }

    public static boolean deleteDirectory(File dir) {
        if (dir != null && dir.exists()) {
            File[] a = dir.listFiles();
            int i = 0;
            while (a != null && i < a.length) {
                if (a[i].isDirectory()) {
                    IOUtility.deleteDirectory(a[i]);
                } else {
                    a[i].delete();
                }
                ++i;
            }
            return dir.delete();
        }
        return true;
    }

    public static boolean deleteDirectory(String dir) {
        File f = IOUtility.toFile(dir);
        if (f != null && f.exists()) {
            return IOUtility.deleteDirectory(f);
        }
        return false;
    }

    public static boolean createDirectory(String dir) {
        if (dir != null) {
            File f = IOUtility.toFile(dir = dir.replaceAll("[*?\\\"<>|]*", ""));
            return f != null && f.mkdirs();
        }
        return false;
    }

    public static boolean deleteFile(String filePath) {
        File f;
        if (filePath != null && (f = IOUtility.toFile(filePath)).exists()) {
            return f.delete();
        }
        return false;
    }

    public static boolean deleteFile(File file) {
        if (file != null && file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static long getFileSize(String filepath) {
        if (filepath == null) {
            return 0L;
        }
        File f = IOUtility.toFile(filepath);
        return IOUtility.getFileSize(f);
    }

    public static long getFileSize(File filepath) {
        if (filepath == null) {
            return 0L;
        }
        if (filepath.exists()) {
            return filepath.length();
        }
        return 0L;
    }

    public static long getFileLastModified(String filepath) {
        if (filepath == null) {
            return 0L;
        }
        File f = IOUtility.toFile(filepath);
        if (f.exists()) {
            return f.lastModified();
        }
        return 0L;
    }

    public static String getFileName(String filepath) {
        if (filepath == null) {
            return null;
        }
        File f = IOUtility.toFile(filepath);
        return f.getName();
    }

    public static File toFile(String s) {
        if (s == null) {
            return null;
        }
        return new File(s.replace('\\', File.separatorChar).replace('/', File.separatorChar));
    }

    public static String getFileExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int i = filename.lastIndexOf(46);
        if (i < 0) {
            return null;
        }
        return filename.substring(i + 1);
    }

    public static String getFilePath(String filepath) {
        if (filepath == null) {
            return null;
        }
        File f = IOUtility.toFile(filepath);
        return f.getParent();
    }

    public static boolean fileExists(String s) {
        if (s != null) {
            File f = IOUtility.toFile(s);
            return f.exists();
        }
        return false;
    }

    public static String getTempFileName(String fileExtension) {
        try {
            File f = File.createTempFile("tmp", fileExtension);
            f.delete();
            return f.getAbsolutePath();
        }
        catch (IOException e) {
            throw new ProcessingException("extension: " + fileExtension, new Object[]{e});
        }
    }

    public static String urlEncode(String url) {
        if (url == null) {
            return null;
        }
        String s = url.trim();
        if (s.isEmpty()) {
            return "";
        }
        try {
            s = URLEncoder.encode(s, StandardCharsets.UTF_8.name());
            s = StringUtility.replace(s, "+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unsupported encoding", (Throwable)e);
        }
        return s;
    }

    public static String urlDecode(String encodedUrl) {
        if (encodedUrl == null) {
            return null;
        }
        String s = encodedUrl.trim();
        if (s.isEmpty()) {
            return "";
        }
        try {
            s = URLDecoder.decode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unsupported encoding", (Throwable)e);
        }
        return s;
    }

    public static URL urlTextToUrl(String urlText) {
        String text = urlText;
        URL url = null;
        if (text != null && !text.isEmpty()) {
            try {
                url = new URL(text);
            }
            catch (MalformedURLException e) {
                text = text.contains("@") ? "mailto:" + text : "http://" + text;
                try {
                    url = new URL(text);
                }
                catch (MalformedURLException e1) {
                    LOG.debug("Could not create url from '{}'", (Object)text, (Object)e1);
                }
            }
        }
        return url;
    }

    public static void appendFile(PrintWriter writer, File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Error appending file: " + file.getName(), new Object[]{e});
        }
    }

    public static List<String> readLines(File file, String charsetName) {
        try {
            return CollectionUtility.arrayList(Files.readAllLines(file.toPath(), Charset.forName(charsetName)));
        }
        catch (IOException e) {
            throw new ProcessingException("Error reading all lines of file '{}'", file, e);
        }
    }

    public static byte[] removeByteOrderMark(byte[] input) {
        if (input == null) {
            return null;
        }
        int skip = 0;
        if (input.length >= 3 && input[0] == -17 && input[1] == -69 && input[2] == -65) {
            skip = 3;
        } else if (input.length >= 2 && input[0] == -2 && input[1] == -1) {
            skip = 2;
        } else if (input.length >= 4 && input[0] == -1 && input[1] == -2 && input[2] != 0 && input[3] != 0) {
            skip = 2;
        } else if (input.length >= 4 && input[0] == 0 && input[1] == 0 && input[2] == -2 && input[3] == -1) {
            skip = 4;
        } else if (input.length >= 4 && input[0] == -1 && input[1] == -2 && input[2] == 0 && input[3] == 0) {
            skip = 4;
        }
        if (skip > 0) {
            return Arrays.copyOfRange(input, skip, input.length);
        }
        return input;
    }
}

