/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.io.Serializable;

public class CellRange
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int m_row1;
    private int m_col1;
    private int m_row2;
    private int m_col2;

    public CellRange(String cells) {
        this.parse(cells);
    }

    public CellRange(int row, int col) {
        this.rangeCheck(row, col);
        this.m_row1 = row;
        this.m_col1 = col;
        this.m_row2 = row;
        this.m_col2 = col;
    }

    public CellRange(int row1, int col1, int row2, int col2) {
        this.rangeCheck(row1, col1);
        this.rangeCheck(row2, col2);
        this.m_row1 = row1;
        this.m_col1 = col1;
        this.m_row2 = row2;
        this.m_col2 = col2;
        this.rangeOrder();
    }

    public boolean isRowsOnly() {
        return this.m_col1 < 0 && this.m_col2 < 0;
    }

    public boolean isColumnsOnly() {
        return this.m_row1 < 0 && this.m_row2 < 0;
    }

    public int getFirstRow() {
        return this.m_row1;
    }

    public int getLastRow() {
        return this.m_row2;
    }

    public int getFirstColumn() {
        return this.m_col1;
    }

    public int getLastColumn() {
        return this.m_col2;
    }

    public int getColumnCount() {
        if (this.isColumnsOnly()) {
            return -1;
        }
        return this.m_col2 - this.m_col1 + 1;
    }

    public int getRowCount() {
        if (this.isRowsOnly()) {
            return -1;
        }
        return this.m_row2 - this.m_row1 + 1;
    }

    public CellRange normalize(int rowCount, int colCount) {
        boolean rowOnly = this.isRowsOnly();
        boolean colOnly = this.isColumnsOnly();
        if (rowOnly || colOnly) {
            CellRange x = new CellRange(this.m_row1, this.m_col1, this.m_row2, this.m_col2);
            if (rowOnly) {
                x.m_col1 = 1;
                x.m_col2 = colCount;
            }
            if (colOnly) {
                x.m_row1 = 1;
                x.m_row2 = rowCount;
            }
            return x;
        }
        return this;
    }

    public String toRangeString() {
        return this.format();
    }

    public String toString() {
        return this.format();
    }

    public String format() {
        if (this.m_row1 == this.m_row2 && this.m_col1 == this.m_col2) {
            return this.formatItem(this.m_row1, this.m_col1);
        }
        return String.valueOf(this.formatItem(this.m_row1, this.m_col1)) + ":" + this.formatItem(this.m_row2, this.m_col2);
    }

    public static String toRangeString(int row, int col) {
        return new CellRange(row, col).format();
    }

    public static String toRangeString(int row1, int col1, int row2, int col2) {
        return new CellRange(row1, col1, row2, col2).format();
    }

    public static CellRange toRange(String s) {
        return new CellRange(s);
    }

    private String formatItem(int row, int col) {
        StringBuilder sb = new StringBuilder();
        while (col >= 0) {
            int n = col % 26;
            if (n == 0 && col >= 26) {
                n = 26;
            }
            if (n > 0) {
                char ch = (char)(65 + n - 1);
                sb.insert(0, ch);
            }
            col = col == 0 ? -1 : (col - n) / 26;
        }
        if (row > 0) {
            sb.append(row);
        }
        return sb.toString();
    }

    public void parse(String s) {
        int p = s.indexOf(58);
        if (p >= 0) {
            int[] a = this.parseItem(s.substring(0, p));
            this.m_row1 = a[0];
            this.m_col1 = a[1];
            a = this.parseItem(s.substring(p + 1));
            this.m_row2 = a[0];
            this.m_col2 = a[1];
        } else {
            int[] a = this.parseItem(s);
            this.m_row1 = a[0];
            this.m_col1 = a[1];
            this.m_row2 = this.m_row1;
            this.m_col2 = this.m_col1;
        }
        this.rangeOrder();
    }

    private int[] parseItem(String s) {
        s = s.toUpperCase();
        int[] a = new int[2];
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch < 'A' || ch > 'Z') break;
            a[1] = a[1] * 26 + (ch - 65 + 1);
            ++i;
        }
        if (a[1] == 0) {
            a[1] = -1;
        }
        if (i < s.length()) {
            a[0] = Integer.parseInt(s.substring(i));
        }
        if (a[0] == 0) {
            a[0] = -1;
        }
        return a;
    }

    private void rangeCheck(int row, int col) {
        if (row == 0 || row < -1 || col == 0 || col < -1) {
            throw new IllegalArgumentException("value must be at least 1 or -1 for wildcards: " + row + "," + col);
        }
    }

    private void rangeOrder() {
        int t;
        if (this.m_row2 < this.m_row1) {
            t = this.m_row2;
            this.m_row2 = this.m_row1;
            this.m_row1 = t;
        }
        if (this.m_col2 < this.m_col1) {
            t = this.m_col2;
            this.m_col2 = this.m_col1;
            this.m_col1 = t;
        }
    }
}

