/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.reflect.FastBeanInfo;
import org.eclipse.scout.rt.platform.reflect.FastPropertyDescriptor;
import org.eclipse.scout.rt.platform.reflect.IPropertyFilter;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanUtility {
    private static final Logger LOG = LoggerFactory.getLogger(BeanUtility.class);
    private static final Object BEAN_INFO_CACHE_LOCK = new Object();
    private static final Map<CompositeObject, FastBeanInfo> BEAN_INFO_CACHE = new HashMap<CompositeObject, FastBeanInfo>();
    private static final Map<Class, Class> PRIMITIVE_COMPLEX_CLASS_MAP = new HashMap<Class, Class>();
    private static final Map<Class, Class> COMPLEX_PRIMITIVE_CLASS_MAP;

    static {
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Byte.TYPE, Byte.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Character.TYPE, Character.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Short.TYPE, Short.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Integer.TYPE, Integer.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Long.TYPE, Long.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Float.TYPE, Float.class);
        PRIMITIVE_COMPLEX_CLASS_MAP.put(Double.TYPE, Double.class);
        COMPLEX_PRIMITIVE_CLASS_MAP = new HashMap<Class, Class>();
        for (Map.Entry<Class, Class> entry : PRIMITIVE_COMPLEX_CLASS_MAP.entrySet()) {
            COMPLEX_PRIMITIVE_CLASS_MAP.put(entry.getValue(), entry.getKey());
        }
    }

    private BeanUtility() {
    }

    public static Map<String, Object> getProperties(Object from, Class<?> stopClazz, IPropertyFilter filter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            FastPropertyDescriptor[] props;
            FastPropertyDescriptor[] fastPropertyDescriptorArray = props = BeanUtility.getFastPropertyDescriptors(from.getClass(), stopClazz, filter);
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                FastPropertyDescriptor fromProp = fastPropertyDescriptorArray[n2];
                Method readMethod = fromProp.getReadMethod();
                if (readMethod != null) {
                    Object value = readMethod.invoke(from, null);
                    map.put(fromProp.getName(), value);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new ProcessingException("object: " + from, new Object[]{e});
        }
        return map;
    }

    public static void setProperties(Object to, Map<String, Object> map, boolean lenient, IPropertyFilter filter) {
        FastBeanInfo toInfo = BeanUtility.getFastBeanInfo(to.getClass(), null);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            try {
                Method writeMethod;
                FastPropertyDescriptor desc = toInfo.getPropertyDescriptor(name);
                if (desc == null || filter != null && !filter.accept(desc) || (writeMethod = desc.getWriteMethod()) == null) continue;
                writeMethod.invoke(to, TypeCastUtility.castValue(value, writeMethod.getParameterTypes()[0]));
            }
            catch (Exception e) {
                if (lenient) {
                    LOG.warn("Could not set property property '{}' to value '{}'", new Object[]{name, value, e});
                    continue;
                }
                throw new ProcessingException("property " + name + " with value " + value, new Object[]{e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FastBeanInfo getFastBeanInfo(Class<?> beanClass, Class<?> stopClass) {
        if (beanClass == null) {
            return new FastBeanInfo(beanClass, stopClass);
        }
        Object object = BEAN_INFO_CACHE_LOCK;
        synchronized (object) {
            CompositeObject key = new CompositeObject(beanClass, stopClass);
            FastBeanInfo info = BEAN_INFO_CACHE.computeIfAbsent(key, k -> new FastBeanInfo(beanClass, stopClass));
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFastBeanInfoCache() {
        Object object = BEAN_INFO_CACHE_LOCK;
        synchronized (object) {
            BEAN_INFO_CACHE.clear();
        }
    }

    public static FastPropertyDescriptor[] getFastPropertyDescriptors(Class<?> clazz, Class<?> stopClazz, IPropertyFilter filter) {
        FastBeanInfo info = BeanUtility.getFastBeanInfo(clazz, stopClazz);
        FastPropertyDescriptor[] a = info.getPropertyDescriptors();
        ArrayList<FastPropertyDescriptor> filteredProperties = new ArrayList<FastPropertyDescriptor>(a.length);
        FastPropertyDescriptor[] fastPropertyDescriptorArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            FastPropertyDescriptor pd = fastPropertyDescriptorArray[n2];
            if (filter == null || filter.accept(pd)) {
                filteredProperties.add(pd);
            }
            ++n2;
        }
        return filteredProperties.toArray(new FastPropertyDescriptor[filteredProperties.size()]);
    }

    public static <T> T createInstance(Class<T> c, Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return BeanUtility.createInstance(c, null, null);
        }
        Class[] parameterTypes = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] != null) {
                parameterTypes[i] = parameters[i].getClass();
            }
            ++i;
        }
        return BeanUtility.createInstance(c, parameterTypes, parameters);
    }

    public static <T> T createInstance(Class<T> c, Class<?>[] parameterTypes, Object[] parameters) {
        Constructor<T> ctor = BeanUtility.findConstructor(c, parameterTypes);
        if (ctor != null) {
            try {
                return ctor.newInstance(parameters);
            }
            catch (Exception t) {
                LOG.info("Exception while instantiating new object [class={}, parameterTypes={}, parameters={}]", new Object[]{c, parameterTypes, parameters, t});
                throw new ProcessingException("Exception while instantiating new object", new Object[]{t});
            }
        }
        return null;
    }

    public static <T> Constructor<T> findConstructor(Class<T> c, Class<?> ... parameterTypes) {
        if (c == null) {
            return null;
        }
        try {
            Constructor<T> ctor = c.getConstructor(parameterTypes);
            if (ctor != null) {
                return ctor;
            }
        }
        catch (NoSuchMethodException e) {
            LOG.debug("exact constructor does not exist");
        }
        if (parameterTypes == null || parameterTypes.length == 0) {
            return null;
        }
        TreeMap<Integer, Set> candidates = new TreeMap<Integer, Set>();
        Constructor<?>[] constructorArray = c.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> ctor = constructorArray[n2];
            int distance = 0;
            Class<?>[] ctorParameters = ctor.getParameterTypes();
            if (ctorParameters.length == parameterTypes.length) {
                int i = 0;
                while (i < parameterTypes.length) {
                    int currentParamDistance = BeanUtility.computeTypeDistance(ctorParameters[i], parameterTypes[i]);
                    if (currentParamDistance == -1 && parameterTypes[i] != null) {
                        if (parameterTypes[i].isPrimitive()) {
                            currentParamDistance = BeanUtility.computeTypeDistance(ctorParameters[i], PRIMITIVE_COMPLEX_CLASS_MAP.get(parameterTypes[i]));
                        } else if (COMPLEX_PRIMITIVE_CLASS_MAP.containsKey(parameterTypes[i])) {
                            currentParamDistance = BeanUtility.computeTypeDistance(ctorParameters[i], COMPLEX_PRIMITIVE_CLASS_MAP.get(parameterTypes[i]));
                        }
                    }
                    if (currentParamDistance == -1) {
                        distance = -1;
                        break;
                    }
                    distance += currentParamDistance;
                    ++i;
                }
                if (distance >= 0) {
                    Constructor<?> candidate = ctor;
                    Set rankedCtors = candidates.computeIfAbsent(distance, k -> new HashSet());
                    rankedCtors.add(candidate);
                }
            }
            ++n2;
        }
        if (candidates.isEmpty()) {
            return null;
        }
        Set ctors = (Set)candidates.firstEntry().getValue();
        if (ctors.isEmpty()) {
            return null;
        }
        if (ctors.size() == 1) {
            return (Constructor)CollectionUtility.firstElement(ctors);
        }
        throw new ProcessingException("More than one constructors found due to ambiguous parameter types [class=" + c + ", parameterTypes=" + Arrays.toString(parameterTypes) + "]", new Object[0]);
    }

    public static int computeTypeDistance(Class<?> declaredType, Class<?> actualType) {
        Class<?>[] superClasses;
        if (declaredType == null) {
            return -1;
        }
        if (actualType == null) {
            return declaredType.isPrimitive() ? -1 : 0;
        }
        if (declaredType == actualType) {
            return 0;
        }
        if (!declaredType.isAssignableFrom(actualType)) {
            return -1;
        }
        Class<?> superClass = actualType.getSuperclass();
        Class<?>[] interfaces = actualType.getInterfaces();
        if (superClass == null) {
            superClasses = interfaces;
        } else {
            superClasses = new Class[interfaces.length + 1];
            superClasses[0] = superClass;
            System.arraycopy(interfaces, 0, superClasses, 1, interfaces.length);
        }
        int minSuperClassesDistance = -1;
        Class<?>[] classArray = superClasses;
        int n = superClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            int distance = BeanUtility.computeTypeDistance(declaredType, c);
            if (distance == 0) {
                minSuperClassesDistance = 0;
                break;
            }
            if (distance > 0) {
                minSuperClassesDistance = minSuperClassesDistance == -1 ? distance : Math.min(minSuperClassesDistance, distance);
            }
            ++n2;
        }
        if (minSuperClassesDistance == -1) {
            return -1;
        }
        return minSuperClassesDistance + 1;
    }

    public static <T> List<Class<? extends T>> getInterfacesHierarchy(Class<?> type, Class<T> filterClass) {
        HashSet<Class> resultSet = new HashSet<Class>();
        ArrayList workList = new ArrayList();
        ArrayList lookAheadList = new ArrayList();
        if (type.isInterface()) {
            lookAheadList.add(type);
        } else {
            Class<?> test = type;
            while (test != null) {
                lookAheadList.addAll(Arrays.asList(test.getInterfaces()));
                test = test.getSuperclass();
            }
        }
        while (!lookAheadList.isEmpty()) {
            workList = lookAheadList;
            lookAheadList = new ArrayList();
            for (Class c : workList) {
                if (resultSet.contains(c)) continue;
                resultSet.add(c);
                Class<?>[] classArray = c.getInterfaces();
                if (classArray.length <= 0) continue;
                lookAheadList.addAll(Arrays.asList(classArray));
            }
        }
        TreeMap resultMap = new TreeMap();
        int index = 0;
        for (Class<?> clazz : resultSet) {
            if (filterClass != null && !filterClass.isAssignableFrom(clazz)) continue;
            int depth = 0;
            Class<?> test = clazz;
            while (test != null) {
                ++depth;
                Class<?>[] xa = test.getInterfaces();
                test = null;
                if (xa == null) continue;
                Class<?>[] classArray = xa;
                int n = xa.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> x = classArray[n2];
                    if (filterClass == null || filterClass.isAssignableFrom(x)) {
                        test = x;
                    }
                    ++n2;
                }
            }
            resultMap.put(new CompositeObject(depth, index++), clazz);
        }
        return CollectionUtility.arrayList(resultMap.values());
    }
}

