/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.transaction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.chain.callable.CallableChain;
import org.eclipse.scout.rt.platform.chain.callable.ICallableDecorator;
import org.eclipse.scout.rt.platform.chain.callable.ICallableInterceptor;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.platform.transaction.ITransactionCommitProtocol;
import org.eclipse.scout.rt.platform.transaction.ITransactionMember;
import org.eclipse.scout.rt.platform.transaction.TransactionRequiredException;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;
import org.eclipse.scout.rt.platform.util.ThreadLocalProcessor;

@Bean
public class TransactionProcessor<RESULT>
implements ICallableInterceptor<RESULT> {
    protected TransactionScope m_transactionScope = TransactionScope.REQUIRES_NEW;
    protected ITransaction m_callerTransaction;
    protected List<ITransactionMember> m_transactionMembers = new ArrayList<ITransactionMember>();

    public TransactionProcessor<RESULT> withTransactionScope(TransactionScope transactionScope) {
        this.m_transactionScope = Assertions.assertNotNull(transactionScope, "transactionScope must not be null", new Object[0]);
        return this;
    }

    public TransactionProcessor<RESULT> withCallerTransaction(ITransaction callerTransaction) {
        this.m_callerTransaction = callerTransaction;
        return this;
    }

    public TransactionProcessor<RESULT> withTransactionMembers(List<ITransactionMember> transactionMembers) {
        this.m_transactionMembers.addAll(transactionMembers);
        return this;
    }

    @Override
    public RESULT intercept(CallableChain.Chain<RESULT> chain) throws Exception {
        this.assertTransactionMemberRegistration();
        switch (this.m_transactionScope) {
            case REQUIRES_NEW: {
                return this.runTxRequiresNew(chain);
            }
            case REQUIRED: {
                return this.runTxRequired(chain);
            }
            case MANDATORY: {
                return this.runTxMandatory(chain);
            }
        }
        return (RESULT)Assertions.fail("Unsupported transaction scope [{}]", new Object[]{this.m_transactionScope});
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected RESULT runTxRequiresNew(CallableChain.Chain<RESULT> chain) throws Exception {
        newTransaction = BEANS.get(ITransaction.class);
        for (ITransactionMember transactionMember : this.m_transactionMembers) {
            newTransaction.registerMember(transactionMember);
        }
        currentTransactionRegistration = this.registerAsCurrentTransaction(newTransaction);
        cancellationRegistration = this.registerTransactionForCancellation(newTransaction);
        var7_5 = chain.continueChain();
        BEANS.get(ITransactionCommitProtocol.class).commitOrRollback(newTransaction);
        currentTransactionRegistration.dispose();
        cancellationRegistration.dispose();
        ** for (transactionMember : this.m_transactionMembers)
lbl-1000:
        // 1 sources

        {
            newTransaction.unregisterMember(transactionMember);
            continue;
        }
lbl16:
        // 1 sources

        return var7_5;
        {
            catch (Throwable t) {
                try {
                    try {
                        newTransaction.addFailure(t);
                        throw BEANS.get(DefaultExceptionTranslator.class).translate(t);
                    }
                    catch (Throwable var6_11) {
                        BEANS.get(ITransactionCommitProtocol.class).commitOrRollback(newTransaction);
                        throw var6_11;
                    }
                }
                catch (Throwable var8_12) {
                    currentTransactionRegistration.dispose();
                    cancellationRegistration.dispose();
                    ** for (transactionMember : this.m_transactionMembers)
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            newTransaction.unregisterMember(transactionMember);
            continue;
        }
lbl31:
        // 1 sources

        throw var8_12;
    }

    protected RESULT runTxRequired(CallableChain.Chain<RESULT> chain) throws Exception {
        if (this.m_callerTransaction != null) {
            return this.runTxMandatory(chain);
        }
        return this.runTxRequiresNew(chain);
    }

    protected RESULT runTxMandatory(CallableChain.Chain<RESULT> chain) throws Exception {
        if (this.m_callerTransaction == null) {
            throw new TransactionRequiredException();
        }
        IRegistrationHandle threadLocalRegistration = this.registerAsCurrentTransaction(this.m_callerTransaction);
        try {
            RESULT RESULT = chain.continueChain();
            return RESULT;
        }
        catch (Throwable t) {
            this.m_callerTransaction.addFailure(t);
            throw t;
        }
        finally {
            threadLocalRegistration.dispose();
        }
    }

    protected IRegistrationHandle registerTransactionForCancellation(ITransaction transaction) {
        RunMonitor.CURRENT.get().registerCancellable(transaction);
        return () -> RunMonitor.CURRENT.get().unregisterCancellable(transaction);
    }

    protected IRegistrationHandle registerAsCurrentTransaction(ITransaction transaction) throws Exception {
        ICallableDecorator.IUndecorator decoration = new ThreadLocalProcessor<ITransaction>(ITransaction.CURRENT, transaction).decorate();
        return decoration::undecorate;
    }

    protected void assertTransactionMemberRegistration() {
        if (this.m_transactionMembers.isEmpty()) {
            return;
        }
        if (this.m_transactionScope == TransactionScope.REQUIRES_NEW || this.m_callerTransaction == null) {
            return;
        }
        Assertions.fail("Registration of transaction members only allowed if starting a new transaction", new Object[0]);
    }
}

