/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.eclipse.scout.rt.platform.serialization.IObjectReplacer;
import org.eclipse.scout.rt.platform.serialization.IObjectSerializer;

public abstract class AbstractObjectSerializer
implements IObjectSerializer {
    private final IObjectReplacer m_objectReplacer;

    public AbstractObjectSerializer(IObjectReplacer objectReplacer) {
        this.m_objectReplacer = objectReplacer;
    }

    public IObjectReplacer getObjectReplacer() {
        return this.m_objectReplacer;
    }

    @Override
    public byte[] serialize(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.serialize(bos, o);
        return bos.toByteArray();
    }

    @Override
    public void serialize(OutputStream out, Object o) throws IOException {
        if (out == null) {
            return;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectOutputStream oos = this.createObjectOutputStream(out, this.getObjectReplacer());){
            oos.writeObject(o);
            oos.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public <T> T deserialize(byte[] buf, Class<T> expectedType) throws IOException, ClassNotFoundException {
        if (buf == null) {
            return null;
        }
        return this.deserialize(new ByteArrayInputStream(buf), expectedType);
    }

    @Override
    public <T> T deserialize(InputStream in, Class<T> expectedType) throws IOException, ClassNotFoundException {
        if (in == null) {
            return null;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (ObjectInputStream ois = this.createObjectInputStream(in, this.getObjectReplacer());){
            Object o = ois.readObject();
            if (expectedType != null && !expectedType.isInstance(o)) {
                throw new IOException("deserialized object has unexpected type: expected '" + expectedType + "', actual '" + o.getClass() + "'.");
            }
            Object castedObject = o;
            return (T)castedObject;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected ObjectOutputStream createObjectOutputStream(OutputStream out, IObjectReplacer objectReplacer) throws IOException {
        if (objectReplacer == null) {
            return new ObjectOutputStream(out);
        }
        return new ReplacingObjectOutputStream(out, objectReplacer);
    }

    protected abstract ObjectInputStream createObjectInputStream(InputStream var1, IObjectReplacer var2) throws IOException;

    private static class ReplacingObjectOutputStream
    extends ObjectOutputStream {
        private final IObjectReplacer m_objectReplacer;

        public ReplacingObjectOutputStream(OutputStream out, IObjectReplacer objectReplacer) throws IOException {
            super(out);
            this.m_objectReplacer = objectReplacer;
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            return this.m_objectReplacer.replaceObject(obj);
        }
    }
}

