/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.security;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.chain.callable.CallableChain;
import org.eclipse.scout.rt.platform.chain.callable.ICallableInterceptor;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class SubjectProcessor<RESULT>
implements ICallableInterceptor<RESULT> {
    protected final Subject m_subject;

    public SubjectProcessor(Subject subject) {
        this.m_subject = subject;
    }

    @Override
    public RESULT intercept(CallableChain.Chain<RESULT> chain) throws Exception {
        try {
            return (RESULT)Subject.doAs(this.m_subject, chain::continueChain);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    @Override
    public boolean isEnabled() {
        return ObjectUtility.notEquals(this.m_subject, Subject.getSubject(AccessController.getContext()));
    }
}

