/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.security;

import java.util.Arrays;

public class KeyPairBytes {
    private final byte[] m_privateKey;
    private final byte[] m_publicKey;

    public KeyPairBytes(byte[] priv, byte[] pub) {
        this.m_privateKey = priv;
        this.m_publicKey = pub;
    }

    public byte[] getPrivateKey() {
        return Arrays.copyOf(this.m_privateKey, this.m_privateKey.length);
    }

    public byte[] getPublicKey() {
        return Arrays.copyOf(this.m_publicKey, this.m_publicKey.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.m_privateKey);
        result = 31 * result + Arrays.hashCode(this.m_publicKey);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyPairBytes other = (KeyPairBytes)obj;
        if (!Arrays.equals(this.m_privateKey, other.m_privateKey)) {
            return false;
        }
        return Arrays.equals(this.m_publicKey, other.m_publicKey);
    }
}

