/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.security.EncryptionKey;
import org.eclipse.scout.rt.platform.security.KeyPairBytes;

@ApplicationScoped
public interface ISecurityProvider {
    public byte[] createMac(byte[] var1, InputStream var2);

    public byte[] createSignature(byte[] var1, InputStream var2);

    public boolean verifySignature(byte[] var1, InputStream var2, byte[] var3);

    public KeyPairBytes createKeyPair();

    public byte[] createHash(InputStream var1, byte[] var2, int var3);

    public byte[] createPasswordHash(char[] var1, byte[] var2, int var3);

    public void encrypt(InputStream var1, OutputStream var2, EncryptionKey var3);

    public void decrypt(InputStream var1, OutputStream var2, EncryptionKey var3);

    public EncryptionKey createEncryptionKey(char[] var1, byte[] var2, int var3);

    public SecureRandom createSecureRandom();

    public byte[] createSecureRandomBytes(int var1);
}

