/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.security;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.config.AbstractBooleanConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.IConfigProperty;
import org.eclipse.scout.rt.platform.security.ICredentialVerifier;
import org.eclipse.scout.rt.platform.security.SecurityUtility;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.Base64Utility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class ConfigFileCredentialVerifier
implements ICredentialVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigFileCredentialVerifier.class);
    private final Map<String, IPassword> m_credentials = new HashMap<String, IPassword>();

    @PostConstruct
    protected void init() {
        this.loadCredentials(BEANS.get(CredentialsProperty.class));
    }

    protected final void loadCredentials(IConfigProperty<String> configProperty) {
        this.m_credentials.clear();
        String credentialsAsLine = configProperty.getValue();
        if (credentialsAsLine == null) {
            return;
        }
        String credentialSample = String.format("%s=scott:salt.password-hash;jack:salt.password-hash;john:salt.password-hash", configProperty.getKey());
        String[] stringArray = credentialsAsLine.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String credentialAsLine = stringArray[n2];
            String[] credential = credentialAsLine.split(":", 2);
            if (credential.length == 2) {
                String username = credential[0];
                if (!StringUtility.hasText(username)) {
                    LOG.warn("Configured username must not be empty. [example={}]", (Object)credentialSample);
                } else {
                    String password = credential[1];
                    if (!StringUtility.hasText(password)) {
                        LOG.warn("Configured password must not be empty. [example={}]", (Object)credentialSample);
                    } else {
                        this.m_credentials.put(username, this.createPassword(password));
                    }
                }
            } else {
                LOG.warn("Username and password must be separated with the 'colon' sign.  [example={}]", (Object)credentialSample);
            }
            ++n2;
        }
    }

    @Override
    public int verify(String username, char[] passwordPlainText) {
        if (StringUtility.isNullOrEmpty(username) || passwordPlainText == null || passwordPlainText.length == 0) {
            return 8;
        }
        IPassword password = this.m_credentials.get(username.toLowerCase());
        if (password == null || !password.isEqual(passwordPlainText)) {
            return 2;
        }
        return 1;
    }

    protected IPassword createPassword(String password) {
        if (((Boolean)CONFIG.getPropertyValue(CredentialPlainTextProperty.class)).booleanValue()) {
            return new PlainTextPassword(password.toCharArray());
        }
        return new HashedPassword(password);
    }

    public static void main(String[] args) {
        String plainTextPassword = args[0];
        System.out.printf("plain-text: %s,  password-hash: %s", plainTextPassword, new HashedPassword(plainTextPassword.toCharArray(), SecurityUtility.createRandomBytes()));
    }

    public static class CredentialPlainTextProperty
    extends AbstractBooleanConfigProperty {
        @Override
        public String getKey() {
            return "scout.auth.credentialsPlaintext";
        }

        @Override
        public String description() {
            return String.format("Specifies if the passwords specified in property '%s' is plaintext (not recommended) or hashed. A value of false indicates hashed passwords which is the default.", BEANS.get(CredentialsProperty.class).getKey());
        }

        @Override
        public Boolean getDefaultValue() {
            return Boolean.FALSE;
        }
    }

    public static class CredentialsProperty
    extends AbstractStringConfigProperty {
        @Override
        public String getKey() {
            return "scout.auth.credentials";
        }

        @Override
        public String description() {
            return String.format("Specifies the known credentials (username & passwords) of the '%s'.\nCredentials are separated by semicolon. Username and password information are separated by colon.\nBy default the password information consists of Base64 encoded salt followed by a dot followed by the Base64 encoded SHA-512 hash of the password (using UTF-16).\nExample: username1:base64EncodedSalt.base64EncodedPasswordHash;username2:base64EncodedSalt.base64EncodedPasswordHash\nTo create a salt and hash tuples based on a clear text password use the '%s.main()' method that can be invoked from the command line.\nIf '%s' is set to 'true' the password information just consists of the cleartext password.", ConfigFileCredentialVerifier.class.getName(), ConfigFileCredentialVerifier.class.getName(), BEANS.get(CredentialPlainTextProperty.class).getKey());
        }
    }

    protected static class HashedPassword
    implements IPassword {
        protected static Charset CHARSET = StandardCharsets.UTF_16;
        private final byte[] m_salt;
        private final byte[] m_hash;

        public HashedPassword(String saltAndHash) {
            String[] tokens = saltAndHash.split("\\.");
            Assertions.assertEqual(2, tokens.length, "Invalid password entry: salt and password-hash are to be separated with the dot (.).", new Object[0]);
            Assertions.assertGreater(tokens[0].length(), 0, "Invalid password entry: 'salt' must not be empty", new Object[0]);
            Assertions.assertGreater(tokens[1].length(), 0, "Invalid password entry: 'password-hash' must not be empty", new Object[0]);
            this.m_salt = Base64Utility.decode(tokens[0]);
            this.m_hash = Base64Utility.decode(tokens[1]);
        }

        private HashedPassword(char[] password, byte[] salt) {
            this.m_salt = salt;
            this.m_hash = this.createPasswordHash(password, salt);
        }

        @Override
        public boolean isEqual(char[] password) {
            return Arrays.equals(this.m_hash, this.createPasswordHash(password, this.m_salt));
        }

        protected byte[] createPasswordHash(char[] password, byte[] salt) {
            return SecurityUtility.hash(this.toBytes(password), salt);
        }

        protected byte[] toBytes(char[] password) {
            ByteBuffer bytes = CHARSET.encode(CharBuffer.wrap(password));
            byte[] result = new byte[bytes.remaining()];
            bytes.get(result);
            return result;
        }

        public String toString() {
            return String.format("%s.%s", Base64Utility.encode(this.m_salt), Base64Utility.encode(this.m_hash));
        }
    }

    @FunctionalInterface
    protected static interface IPassword {
        public boolean isEqual(char[] var1);
    }

    protected static class PlainTextPassword
    implements IPassword {
        private final char[] m_password;

        public PlainTextPassword(char[] password) {
            this.m_password = password;
        }

        @Override
        public boolean isEqual(char[] password) {
            return Arrays.equals(this.m_password, password);
        }
    }
}

