/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.resource;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.date.IDateProvider;

public final class BinaryResources {
    private String m_filename;
    private String m_contentType;
    private String m_charset;
    private byte[] m_content;
    private long m_lastModified = -1L;
    private boolean m_cachingAllowed = false;
    private int m_cacheMaxAge = 0;

    private BinaryResources() {
    }

    public static BinaryResources create() {
        return new BinaryResources();
    }

    public static BinaryResources create(BinaryResource resource) {
        return BinaryResources.create().withFilename(resource.getFilename()).withContentType(resource.getContentType()).withCharset(resource.getCharset()).withContent(resource.getContent()).withLastModified(resource.getLastModified()).withCachingAllowed(resource.isCachingAllowed()).withCacheMaxAge(resource.getCacheMaxAge());
    }

    public BinaryResources withFilename(String filename) {
        this.m_filename = filename;
        return this;
    }

    public BinaryResources withContentType(String contentType) {
        this.m_contentType = contentType;
        return this;
    }

    public BinaryResources withCharset(Charset charset) {
        this.m_charset = charset == null ? null : charset.name();
        return this;
    }

    public BinaryResources withCharset(String charset) {
        this.m_charset = charset;
        return this;
    }

    public BinaryResources withContent(byte[] content) {
        this.m_content = content;
        return this;
    }

    public BinaryResources withContent(String content) {
        return this.withContent(content, StandardCharsets.UTF_8);
    }

    public BinaryResources withContent(String content, Charset charset) {
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        this.m_content = content == null ? null : content.getBytes(charset);
        this.m_charset = content == null ? null : charset.name();
        return this;
    }

    public BinaryResources withLastModified(long lastModified) {
        this.m_lastModified = lastModified;
        return this;
    }

    public BinaryResources withLastModifiedNow() {
        return this.withLastModified(BEANS.get(IDateProvider.class).currentMillis().getTime());
    }

    public BinaryResources withCachingAllowed(boolean enabled) {
        this.m_cachingAllowed = enabled;
        return this;
    }

    public BinaryResources withCacheMaxAge(int cacheMaxAge) {
        this.m_cacheMaxAge = cacheMaxAge;
        return this;
    }

    public BinaryResource build() {
        return new BinaryResource(this.m_filename, this.m_contentType, this.m_charset, this.m_content, this.m_lastModified, this.m_cachingAllowed, this.m_cacheMaxAge);
    }
}

