/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;

public final class ReflectionUtility {
    private ReflectionUtility() {
    }

    public static void removeFinalFlagOnField(Field f) throws NoSuchFieldException, IllegalAccessException {
        Field reflectedModifier = Field.class.getDeclaredField("modifiers");
        reflectedModifier.setAccessible(true);
        int modifiers = (Integer)reflectedModifier.get(f);
        reflectedModifier.set(f, modifiers &= 0xFFFFFFEF);
        reflectedModifier.setAccessible(false);
    }

    public static void setFinalFlagOnField(Field f) throws NoSuchFieldException, IllegalAccessException {
        Field reflectedModifier = Field.class.getDeclaredField("modifiers");
        reflectedModifier.setAccessible(true);
        int modifiers = (Integer)reflectedModifier.get(f);
        reflectedModifier.set(f, modifiers |= 0x10);
        reflectedModifier.setAccessible(false);
    }

    public static Class<?>[] getInterfaces(Class<?> clazz) {
        if (clazz.isInterface()) {
            return new Class[]{clazz};
        }
        HashSet interfaces = new HashSet();
        while (!Object.class.equals(clazz)) {
            interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public static Constructor<?> getConstructor(Class<?> clazz, Class<?>[] paramTypes) {
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> candidate = constructorArray[n2];
            if (Arrays.equals(paramTypes, candidate.getParameterTypes())) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    public static <ANNOTATION extends Annotation> ANNOTATION getAnnotation(Class<ANNOTATION> annotationClass, AnnotatedElement ... elements) {
        AnnotatedElement[] annotatedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotatedElement element = annotatedElementArray[n2];
            ANNOTATION annotation = element.getAnnotation(annotationClass);
            if (annotation != null) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }
}

