/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.platform.reflect;

import java.util.Collections;
import java.util.Map;
import org.eclipse.scout.rt.platform.reflect.FastBeanUtility;
import org.eclipse.scout.rt.platform.reflect.FastPropertyDescriptor;

public class FastBeanInfo {
    private final Class m_beanClass;
    private final Map<String, FastPropertyDescriptor> m_propertyMap;
    private final FastPropertyDescriptor[] m_propertyArray;

    public FastBeanInfo(Class<?> beanClass, Class<?> stopClass) {
        this.m_beanClass = beanClass;
        this.m_propertyMap = Collections.unmodifiableMap(FastBeanUtility.createPropertyDescriptorMap(beanClass, stopClass));
        this.m_propertyArray = this.m_propertyMap.values().toArray(new FastPropertyDescriptor[this.m_propertyMap.size()]);
    }

    public Class getBeanClass() {
        return this.m_beanClass;
    }

    public Map<String, FastPropertyDescriptor> getPropertyDescriptorMap() {
        return this.m_propertyMap;
    }

    public FastPropertyDescriptor getPropertyDescriptor(String name) {
        FastPropertyDescriptor p = this.m_propertyMap.get(name);
        if (p == null && !name.isEmpty()) {
            p = Character.isUpperCase(name.charAt(0)) ? this.m_propertyMap.get(String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1)) : this.m_propertyMap.get(String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1));
        }
        return p;
    }

    public FastPropertyDescriptor[] getPropertyDescriptors() {
        return this.m_propertyArray;
    }
}

